/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.utils.Util;

@Consumes(value={"application/vnd.oracle.glassfish+json"})
public class RestModelListReader
implements MessageBodyReader<List<RestModel>> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String submittedType = mediaType.toString();
        int index = submittedType.indexOf(59);
        if (index > -1) {
            submittedType = submittedType.substring(0, index);
        }
        return submittedType.equals("application/vnd.oracle.glassfish+json") && List.class.isAssignableFrom(type) && RestModel.class.isAssignableFrom(Util.getFirstGenericType(genericType));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RestModel> readFrom(Class<List<RestModel>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(entityStream));){
            ArrayList<RestModel> arrayList;
            block18: {
                JsonParser parser = Json.createParser((Reader)in);
                try {
                    JsonArray array;
                    Locale locale = CompositeUtil.instance().getLocale(httpHeaders);
                    ArrayList<RestModel> list = new ArrayList<RestModel>();
                    if (parser.hasNext()) {
                        parser.next();
                        array = parser.getArray();
                    } else {
                        array = JsonValue.EMPTY_JSON_ARRAY;
                    }
                    Class modelType = null;
                    if (genericType instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)genericType;
                        modelType = (Class)pt.getActualTypeArguments()[0];
                    }
                    for (int i = 0; i < array.size(); ++i) {
                        JsonObject o = array.getJsonObject(i);
                        RestModel model = (RestModel)CompositeUtil.instance().unmarshallClass(locale, modelType, o);
                        Set cv = CompositeUtil.instance().validateRestModel(locale, model);
                        if (!cv.isEmpty()) {
                            Response response = Response.status(Response.Status.BAD_REQUEST).entity(CompositeUtil.instance().getValidationFailureMessages(locale, cv, model)).build();
                            throw new WebApplicationException(response);
                        }
                        list.add(model);
                    }
                    arrayList = list;
                    if (parser == null) break block18;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw new WebApplicationException(e);
        }
    }
}

