/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.resources.TemplateRestResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.GetResultList;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.config.support.TranslatedConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

public class PropertiesBagResource
extends AbstractResource {
    protected List<Dom> entity;
    protected Dom parent;
    protected String tagName;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PropertiesBagResource.class);

    @Path(value="{Name}/")
    public PropertyResource getProperty(@PathParam(value="Name") String id) {
        PropertyResource resource = (PropertyResource)this.serviceLocator.createAndInitialize(PropertyResource.class);
        resource.setBeanByKey(this.getEntity(), id, this.tagName);
        return resource;
    }

    @GET
    @Produces(value={"text/html", "application/json", "application/xml"})
    public Object get() {
        List<Dom> entities = this.getEntity();
        if (entities == null) {
            return new GetResultList(new ArrayList<Dom>(), "", new String[0][], new OptionsResult(Util.getResourceName(this.uriInfo)));
        }
        RestActionReporter ar = new RestActionReporter();
        ar.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ar.setActionDescription("property");
        ArrayList properties = new ArrayList();
        for (Dom child : entities) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", child.attribute("name"));
            entry.put("value", child.attribute("value"));
            String description = child.attribute("description");
            if (description != null) {
                entry.put("description", description);
            }
            properties.add(entry);
        }
        Properties extraProperties = new Properties();
        extraProperties.put("properties", properties);
        ar.setExtraProperties(extraProperties);
        return new ActionReportResult("properties", ar, new OptionsResult(Util.getResourceName(this.uriInfo)));
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html", "application/json", "application/xml"})
    public ActionReportResult createProperties(List<Map<String, String>> data) {
        return this.clearThenSaveProperties(data);
    }

    @PUT
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html", "application/json", "application/xml"})
    public ActionReportResult replaceProperties(List<Map<String, String>> data) {
        return this.clearThenSaveProperties(data);
    }

    @DELETE
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded", "application/octet-stream"})
    @Produces(value={"text/html", "application/json", "application/xml"})
    public Response delete() {
        try {
            Map<String, Property> existing = this.getExistingProperties();
            this.deleteMissingProperties(existing, null);
            String successMessage = localStrings.getLocalString("rest.resource.delete.message", "\"{0}\" deleted successfully.", new Object[]{this.uriInfo.getAbsolutePath()});
            return ResourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                return ResourceUtil.getResponse(400, ex.getMessage(), this.requestHeaders, this.uriInfo);
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getEscapedPropertyName(String propName) {
        return propName.replaceAll("\\.", "\\\\\\.");
    }

    protected ActionReportResult clearThenSaveProperties(List<Map<String, String>> properties) {
        RestActionReporter ar = new RestActionReporter();
        ar.setActionDescription("property");
        try {
            TranslatedConfigView.doSubstitution.set(Boolean.FALSE);
            Map<String, Property> existing = this.getExistingProperties();
            this.deleteMissingProperties(existing, properties);
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> descriptionData = new LinkedHashMap<String, String>();
            for (Map<String, String> property : properties) {
                Property existingProp = existing.get(property.get("name"));
                String unescapedName = property.get("name");
                String escapedName = this.getEscapedPropertyName(unescapedName);
                String value = property.get("value");
                String unescapedValue = value.replaceAll("\\\\", "");
                String description = null;
                if (property.get("description") != null) {
                    description = property.get("description");
                }
                boolean isDottedName = property.get("name").contains(".");
                if (existingProp == null || !unescapedValue.equals(existingProp.getValue())) {
                    data.put(escapedName, property.get("value"));
                    if (isDottedName) {
                        data.put(unescapedName + ".name", unescapedName);
                    }
                    if (description != null) {
                        descriptionData.put(unescapedName + ".description", description);
                    }
                }
                if (description == null || existingProp == null || "".equals(description) || description.equals(existingProp.getDescription())) continue;
                descriptionData.put(unescapedName + ".description", description);
            }
            if (!data.isEmpty() || !descriptionData.isEmpty()) {
                Util.applyChanges(data, this.uriInfo, this.getSubject());
                Util.applyChanges(descriptionData, this.uriInfo, this.getSubject());
            }
            String successMessage = localStrings.getLocalString("rest.resource.update.message", "\"{0}\" updated successfully.", new Object[]{this.uriInfo.getAbsolutePath()});
            ar.setSuccess();
            ar.setMessage(successMessage);
        }
        catch (ValidationException ex) {
            ar.setFailure();
            ar.setFailureCause(ex);
            ar.setMessage(ex.getLocalizedMessage());
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Error processing properties", ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            TranslatedConfigView.doSubstitution.set(Boolean.TRUE);
        }
        return new ActionReportResult("properties", ar, new OptionsResult(Util.getResourceName(this.uriInfo)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Property> getExistingProperties() {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        if (this.parent != null) {
            List children;
            Dom dom = this.parent;
            synchronized (dom) {
                children = this.parent.nodeElements(this.tagName);
            }
            for (Dom child : children) {
                Property property = (Property)child.createProxy();
                properties.put(property.getName(), property);
            }
        }
        return properties;
    }

    protected void deleteMissingProperties(Map<String, Property> existing, List<Map<String, String>> properties) throws TransactionFailure {
        HashSet<String> propNames = new HashSet<String>();
        if (properties != null) {
            for (Map<String, String> property : properties) {
                propNames.add(property.get("name"));
            }
        }
        HashMap<String, String> data = new HashMap<String, String>();
        for (Property existingProp : existing.values()) {
            if (propNames.contains(existingProp.getName())) continue;
            String escapedName = this.getEscapedPropertyName(existingProp.getName());
            data.put(escapedName, "");
        }
        if (!data.isEmpty()) {
            Util.applyChanges(data, this.uriInfo, this.getSubject());
        }
    }

    public void setEntity(List<Dom> p) {
        this.entity = p;
    }

    public List<Dom> getEntity() {
        return this.entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        if (parent != null) {
            Dom dom = parent;
            synchronized (dom) {
                this.entity = parent.nodeElements(tagName);
            }
        }
    }

    public static class PropertyResource
    extends TemplateRestResource {
        @Override
        public String getDeleteCommand() {
            return "GENERIC-DELETE";
        }
    }
}

