/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.Dom;

public class JmxServiceUrlsResource {
    @Context
    protected ServiceLocator habitat;

    public void setEntity(Dom p) {
    }

    @GET
    @Produces(value={"text/html", "application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult getJmxServiceUrl() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            JMXServiceURL[] urls = (JMXServiceURL[])mBeanServer.getAttribute(this.getBootAMXMBeanObjectName(), "JMXServiceURLs");
            ArrayList<String> jmxUrls = new ArrayList<String>();
            for (JMXServiceURL url : urls) {
                jmxUrls.add(url.getURLPath());
            }
            RestActionReporter ar = new RestActionReporter();
            ar.setActionDescription("Get JMX Service URLs");
            ar.setSuccess();
            ar.getExtraProperties().put("jmxServiceUrls", jmxUrls);
            return new ActionReportResult(ar);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectName getBootAMXMBeanObjectName() {
        try {
            return new ObjectName("amx-support:type=boot-amx");
        }
        catch (Exception e) {
            throw new RuntimeException("bad ObjectName", e);
        }
    }
}

