/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.composite.metadata.Confidential;
import org.glassfish.admin.rest.model.ResponseBody;
import org.glassfish.admin.rest.utils.StringUtil;

public class JsonUtil {
    public static final String CONFIDENTIAL_PROPERTY_SET = "@_Oracle_Confidential_Property_Set_V1.1_#";
    public static final String CONFIDENTIAL_PROPERTY_UNSET = null;

    private JsonUtil() {
    }

    public static JsonValue getJsonValue(Object object) throws JsonException {
        return JsonUtil.getJsonValue(object, true);
    }

    public static JsonValue getJsonValue(Object object, boolean hideConfidentialProperties) throws JsonException {
        JsonValue result;
        if (object == null) {
            result = JsonValue.NULL;
        } else if (object instanceof Collection) {
            result = JsonUtil.processCollection((Collection)object);
        } else if (object instanceof Map) {
            result = JsonUtil.processMap((Map)object);
        } else if (RestModel.class.isAssignableFrom(object.getClass())) {
            result = JsonUtil.getJsonForRestModel((RestModel)object, hideConfidentialProperties);
        } else if (object instanceof ResponseBody) {
            result = ((ResponseBody)object).toJson();
        } else if (object instanceof String) {
            result = Json.createValue((String)((String)object));
        } else if (object instanceof Boolean) {
            Boolean value = (Boolean)object;
            result = value.booleanValue() ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (object instanceof Double) {
            result = Json.createValue((Number)((Double)object));
        } else if (object instanceof Integer) {
            result = Json.createValue((Number)((Integer)object));
        } else if (object instanceof Long) {
            result = Json.createValue((Number)((Long)object));
        } else if (object instanceof JsonValue) {
            result = (JsonValue)object;
        } else if (object instanceof BigInteger) {
            result = Json.createValue((BigInteger)((BigInteger)object));
        } else if (object instanceof BigDecimal) {
            result = Json.createValue((BigDecimal)((BigDecimal)object));
        } else if (object.getClass().isEnum()) {
            result = Json.createValue((String)object.toString());
        } else if (object instanceof InetAddress) {
            result = Json.createValue((String)object.toString());
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                JsonArrayBuilder array = Json.createArrayBuilder();
                int lenth = Array.getLength(object);
                for (int i = 0; i < lenth; ++i) {
                    array.add(JsonUtil.getJsonValue(Array.get(object, i)));
                }
                result = array.build();
            } else {
                throw new JsonException("Unable to convert object to JsonValue: " + object);
            }
        }
        return result;
    }

    @Deprecated
    public static JsonValue getJsonObject(Object object, boolean hideConfidentialProperties) throws JsonException {
        return JsonUtil.getJsonValue(object, hideConfidentialProperties);
    }

    public static JsonObject getJsonForRestModel(RestModel model, boolean hideConfidentialProperties) {
        JsonObjectBuilder result = Json.createObjectBuilder();
        for (Method m : model.getClass().getDeclaredMethods()) {
            if (!m.getName().startsWith("get")) continue;
            Object propName = m.getName().substring(3);
            propName = ((String)propName).substring(0, 1).toLowerCase(Locale.getDefault()) + ((String)propName).substring(1);
            if (model.isTrimmed() && !model.isSet((String)propName)) continue;
            try {
                result.add((String)propName, JsonUtil.getJsonValue(JsonUtil.getRestModelProperty(model, m, hideConfidentialProperties)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.build();
    }

    private static Object getRestModelProperty(RestModel model, Method method, boolean hideConfidentialProperties) throws Exception {
        Object object = method.invoke((Object)model, new Object[0]);
        if (hideConfidentialProperties && JsonUtil.isConfidentialString(model, method)) {
            String str = (String)object;
            return StringUtil.notEmpty(str) ? CONFIDENTIAL_PROPERTY_SET : CONFIDENTIAL_PROPERTY_UNSET;
        }
        return object;
    }

    private static boolean isConfidentialString(RestModel model, Method method) {
        if (!String.class.equals(method.getReturnType())) {
            return false;
        }
        return JsonUtil.isConfidentialProperty(model.getClass(), method.getName());
    }

    public static boolean isConfidentialProperty(Class clazz, String getterMethodName) {
        if (JsonUtil.getConfidentialAnnotation(clazz, getterMethodName) != null) {
            return true;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (JsonUtil.getConfidentialAnnotation(iface, getterMethodName) == null) continue;
            return true;
        }
        return false;
    }

    private static Confidential getConfidentialAnnotation(Class clazz, String getterMethodName) {
        try {
            Method m = clazz.getDeclaredMethod(getterMethodName, new Class[0]);
            return m.getAnnotation(Confidential.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JsonArray processCollection(Collection c) throws JsonException {
        JsonArrayBuilder result = Json.createArrayBuilder();
        for (Object item : c) {
            result.add(JsonUtil.getJsonValue(item));
        }
        return result.build();
    }

    public static JsonObject processMap(Map map) throws JsonException {
        JsonObjectBuilder result = Json.createObjectBuilder();
        for (Map.Entry entry : map.entrySet()) {
            result.add(entry.getKey().toString(), JsonUtil.getJsonValue(entry.getValue()));
        }
        return result.build();
    }

    public static String getString(JsonObject jsonObject, String key, String dflt) {
        try {
            if (jsonObject.isNull(key)) {
                return null;
            }
            return jsonObject.getString(key, dflt);
        }
        catch (JsonException e) {
            return dflt;
        }
    }

    public static int getInt(JsonObject jsonObject, String key, int dflt) {
        try {
            return jsonObject.getInt(key, dflt);
        }
        catch (JsonException e) {
            return dflt;
        }
    }

    public static JsonObject accumalate(JsonObject jsonObject, String key, JsonValue value) {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder((JsonObject)jsonObject);
        if (jsonObject.containsKey((Object)key)) {
            JsonValue previous = (JsonValue)jsonObject.get((Object)key);
            if (previous instanceof JsonArray) {
                JsonArrayBuilder prev = Json.createArrayBuilder((JsonArray)((JsonArray)previous));
                prev.add(value);
                jsonBuilder.add(key, prev);
            } else {
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                arrayBuilder.add(previous);
                arrayBuilder.add(value);
                jsonBuilder.add(key, arrayBuilder);
            }
        } else {
            jsonBuilder.add(key, value);
        }
        return jsonBuilder.build();
    }

    public static Map<String, Object> jsonObjectToMap(JsonObject object) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set keys = object.keySet();
        for (String key : keys) {
            result.put(key, JsonUtil.jsonValueToRaw((JsonValue)object.get((Object)key)));
        }
        return result;
    }

    public static List<Object> jsonArraytoArray(JsonArray array) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (JsonValue instance : array) {
            result.add(JsonUtil.jsonValueToRaw(instance));
        }
        return result;
    }

    public static Object jsonValueToRaw(JsonValue value) {
        JsonValue.ValueType type = value.getValueType();
        switch (type) {
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                return ((JsonNumber)value).bigDecimalValue();
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case NULL: {
                return null;
            }
            case OBJECT: {
                return JsonUtil.jsonObjectToMap((JsonObject)value);
            }
            case ARRAY: {
                return JsonUtil.jsonArraytoArray((JsonArray)value);
            }
        }
        throw new JsonException("JsonValue is not a recognised ValueType");
    }
}

