/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.amx.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.admin.amx.AMXBootService;
import fish.payara.admin.amx.config.AMXConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.amx.util.AMXLoggerInfo;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-amx-enabled")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.DEPLOYMENT_GROUP, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-amx-enabled", description="Sets whether AMX in enabled")})
public class SetAmxEnabled
implements AdminCommand {
    private static final Logger LOGGER = AMXLoggerInfo.getLogger();
    @Param(name="enabled", optional=true, defaultValue="true")
    Boolean enabled;
    @Param(name="dynamic", optional=true, defaultValue="true")
    private Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server-config")
    private String target;
    @Inject
    ServiceLocator habitat;
    @Inject
    private Target targetUtil;

    public void execute(AdminCommandContext context) {
        final ActionReport actionReport = context.getActionReport();
        Config targetConfig = this.targetUtil.getConfig(this.target);
        AMXConfiguration metricsConfiguration = (AMXConfiguration)targetConfig.getExtensionByType(AMXConfiguration.class);
        try {
            ConfigSupport.apply(new SingleConfigCode<AMXConfiguration>(){

                @Override
                public Object run(AMXConfiguration configProxy) throws PropertyVetoException, TransactionFailure {
                    configProxy.setEnabled(SetAmxEnabled.this.enabled.toString());
                    actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return configProxy;
                }
            }, metricsConfiguration);
            AMXBootService bootService = (AMXBootService)this.habitat.getService(AMXBootService.class, new Annotation[0]);
            bootService.setEnabled(this.enabled, this.dynamic);
        }
        catch (TransactionFailure ex) {
            LOGGER.log(Level.WARNING, "Exception during command set-amx-enabled: {0}", ex.getCause().getMessage());
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

