/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.util.UUID;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;

public class UUIDConverter
implements Converter {
    @Override
    public Object convertObjectValueToDataValue(Object uuidValue, Session session) {
        if (uuidValue instanceof UUID) {
            return uuidValue.toString();
        }
        throw new IllegalArgumentException("Source object is not an instance of java.util.UUID");
    }

    @Override
    public Object convertDataValueToObjectValue(Object jdbcValue, Session session) {
        return UUID.fromString(jdbcValue.toString());
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        if (mapping.isDirectToFieldMapping() && ((AbstractDirectMapping)mapping).getFieldClassification() == null) {
            AbstractDirectMapping directMapping = (AbstractDirectMapping)AbstractDirectMapping.class.cast(mapping);
            Class<?> attributeClassification = mapping.getAttributeClassification();
            if (attributeClassification.isInstance(UUID.class)) {
                directMapping.setFieldClassification(UUID.class);
            }
        }
    }
}

