/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.environment.warning.config.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.appserver.environment.warning.config.EnvironmentWarningConfiguration;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-environment-warning-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-environment-warning-configuration", description="Gets the Environment Warning Configuration")})
public class GetEnvironmentWarningConfigurationCommand
implements AdminCommand {
    @Inject
    private Target targetUtil;
    private final String config = "server-config";

    public void execute(AdminCommandContext acc) {
        Config configNode = this.targetUtil.getConfig("server-config");
        EnvironmentWarningConfiguration environmentWarningConfiguration = (EnvironmentWarningConfiguration)configNode.getExtensionByType(EnvironmentWarningConfiguration.class);
        ActionReport actionReport = acc.getActionReport();
        String[] outputHeaders = new String[]{"Enabled", "Message", "Background Colour", "Text Colour"};
        ColumnFormatter columnFormatter = new ColumnFormatter(outputHeaders);
        Object[] outputValues = new Object[]{environmentWarningConfiguration.isEnabled(), environmentWarningConfiguration.getMessage(), environmentWarningConfiguration.getBackgroundColour(), environmentWarningConfiguration.getTextColour()};
        columnFormatter.addRow(outputValues);
        actionReport.appendMessage(columnFormatter.toString());
        HashMap<String, String> extraPropsMap = new HashMap<String, String>();
        extraPropsMap.put("enabled", environmentWarningConfiguration.isEnabled());
        extraPropsMap.put("message", environmentWarningConfiguration.getMessage());
        extraPropsMap.put("backgroundColour", environmentWarningConfiguration.getBackgroundColour());
        extraPropsMap.put("textColour", environmentWarningConfiguration.getTextColour());
        Properties extraProps = new Properties();
        extraProps.put("environmentWarningConfiguration", extraPropsMap);
        actionReport.setExtraProperties(extraProps);
    }
}

