/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.nucleus.microprofile.config.admin.SetConfigOrdinal;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-config-ordinal")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-config-ordinal", description="Gets the Ordinal of a builtin Config Source")})
public class GetConfigOrdinal
implements AdminCommand {
    @Param(optional=true, acceptableValues="domain,config,server,application,module,cluster,jndi,secrets,password,jdbc,cloud,ldap", defaultValue="domain")
    String source;
    @Param(optional=true, defaultValue="server")
    String target;
    @Inject
    Target targetUtil;

    public void execute(AdminCommandContext context) {
        Config configVal = this.targetUtil.getConfig(this.target);
        MicroprofileConfigConfiguration serviceConfig = (MicroprofileConfigConfiguration)configVal.getExtensionByType(MicroprofileConfigConfiguration.class);
        if (serviceConfig != null) {
            Integer result = -1;
            switch (this.source) {
                case "domain": {
                    result = Integer.parseInt(serviceConfig.getDomainOrdinality());
                    break;
                }
                case "config": {
                    result = Integer.parseInt(serviceConfig.getConfigOrdinality());
                    break;
                }
                case "server": {
                    result = Integer.parseInt(serviceConfig.getServerOrdinality());
                    break;
                }
                case "application": {
                    result = Integer.parseInt(serviceConfig.getApplicationOrdinality());
                    break;
                }
                case "module": {
                    result = Integer.parseInt(serviceConfig.getModuleOrdinality());
                    break;
                }
                case "cluster": {
                    result = Integer.parseInt(serviceConfig.getClusterOrdinality());
                    break;
                }
                case "jndi": {
                    result = Integer.parseInt(serviceConfig.getJndiOrdinality());
                    break;
                }
                case "secrets": {
                    result = Integer.parseInt(serviceConfig.getSecretDirOrdinality());
                    break;
                }
                case "password": {
                    result = Integer.parseInt(serviceConfig.getPasswordOrdinality());
                    break;
                }
                case "jdbc": {
                    result = Integer.parseInt(serviceConfig.getJdbcOrdinality());
                    break;
                }
                case "cloud": {
                    result = Integer.parseInt(serviceConfig.getCloudOrdinality());
                    break;
                }
                case "ldap": {
                    result = Integer.parseInt(serviceConfig.getLdapOrdinality());
                }
            }
            context.getActionReport().setMessage(this.source + " : " + result.toString());
            HashMap<String, Object> extraPropertiesMap = new HashMap<String, Object>();
            extraPropertiesMap.put("source", this.source);
            extraPropertiesMap.put("ordinal", result);
            Properties extraProperties = new Properties();
            extraProperties.put("configConfiguration", extraPropertiesMap);
            context.getActionReport().setExtraProperties(extraProperties);
        } else {
            context.getActionReport().failure(Logger.getLogger(SetConfigOrdinal.class.getName()), "No configuration with name " + this.target);
        }
    }
}

