/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.nucleus.microprofile.config.spi.JDBCConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import jakarta.inject.Inject;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-jdbc-config-source-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-jdbc-config-source-configuration", description="Configures JDBC Config Source")})
public class SetJDBCConfigSourceConfiguration
implements AdminCommand {
    private static final Logger LOGGER = Logger.getLogger(SetJDBCConfigSourceConfiguration.class.getName());
    @Param
    private String jndiName;
    @Param
    private String tableName;
    @Param
    private String keyColumnName;
    @Param
    private String valueColumnName;
    @Inject
    private Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;

    public void execute(AdminCommandContext acc) {
        ActionReport actionReport = acc.getActionReport();
        Config targetConfig = this.targetUtil.getConfig(this.target);
        if (targetConfig == null) {
            actionReport.setMessage("No such config named: " + this.target);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        JDBCConfigSourceConfiguration jdbcConfigSourceConfiguration = (JDBCConfigSourceConfiguration)targetConfig.getExtensionByType(JDBCConfigSourceConfiguration.class);
        try {
            ConfigSupport.apply(configProxy -> {
                if (this.jndiName != null) {
                    configProxy.setJndiName(this.jndiName);
                }
                if (this.tableName != null) {
                    configProxy.setTableName(this.tableName);
                }
                if (this.keyColumnName != null) {
                    configProxy.setKeyColumnName(this.keyColumnName);
                }
                if (this.valueColumnName != null) {
                    configProxy.setValueColumnName(this.valueColumnName);
                }
                actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return configProxy;
            }, (ConfigBeanProxy)jdbcConfigSourceConfiguration);
        }
        catch (TransactionFailure ex) {
            actionReport.failure(LOGGER, "Failed to update JDBC Config Source configuration", (Throwable)ex);
        }
    }
}

