/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.converters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.Converter;

public class AutomaticConverter {
    public static <T> Optional<Converter<T>> forType(Class<T> type) {
        return Stream.of(() -> AutomaticConverter.forMethod(type, "of", String.class), () -> AutomaticConverter.forMethod(type, "valueOf", String.class), () -> AutomaticConverter.forMethod(type, "parse", CharSequence.class), () -> AutomaticConverter.forConstructor(type, String.class)).map(Supplier::get).filter(converter -> converter != null).findFirst();
    }

    private static <T> Converter<T> forMethod(Class<T> type, String method, Class<?> ... argumentTypes) {
        try {
            Method factoryMethod = type.getMethod(method, argumentTypes);
            if (Modifier.isStatic(factoryMethod.getModifiers()) && Modifier.isPublic(factoryMethod.getModifiers()) && factoryMethod.getReturnType() == type) {
                return new MethodConverter(factoryMethod);
            }
            return null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private static <T> Converter<T> forConstructor(Class<T> type, Class<?> ... argumentTypes) {
        try {
            Constructor<T> constructor = type.getConstructor(argumentTypes);
            if (Modifier.isPublic(constructor.getModifiers())) {
                return new ConstructorConverter<T>(constructor);
            }
            return null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private static final class ConstructorConverter<T>
    implements Converter<T> {
        private final Constructor<T> constructor;

        ConstructorConverter(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        public T convert(String value) {
            if (value == null || value.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                return null;
            }
            try {
                return this.constructor.newInstance(value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                throw new IllegalArgumentException("Unable to convert value to type " + this.constructor.getDeclaringClass().getName() + " for value `" + value + "`", ex);
            }
        }
    }

    private static final class MethodConverter<T>
    implements Converter<T> {
        private final Method conversionMethod;

        MethodConverter(Method conversionMethod) {
            this.conversionMethod = conversionMethod;
        }

        public T convert(String value) {
            if (value == null || value.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                return null;
            }
            try {
                return (T)this.conversionMethod.invoke(null, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new IllegalArgumentException("Unable to convert value to type " + this.conversionMethod.getReturnType().getName() + " for value `" + value + "`", ex);
            }
        }
    }
}

