/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.converters;

import jakarta.annotation.Priority;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=1)
public class InetAddressConverter
implements Converter<InetAddress> {
    public InetAddress convert(String value) {
        if (value == null) {
            throw new NullPointerException("Cannot convert null value");
        }
        if (value.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
            return null;
        }
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

