/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;

public class PayaraServerProperties
extends PayaraConfigSource {
    private HashMap<String, String> properties;

    public PayaraServerProperties() {
        ServerEnvironment server = Globals.getDefaultHabitat().getService(ServerEnvironment.class, new Annotation[0]);
        ServerContext serverCtx = Globals.getDefaultHabitat().getService(ServerContext.class, new Annotation[0]);
        this.properties = new HashMap(20);
        this.properties.put("payara.instance.type", server.getRuntimeType().name());
        this.properties.put("payara.instance.name", server.getInstanceName());
        this.properties.put("payara.instance.root", server.getInstanceRoot().getAbsolutePath());
        this.properties.put("payara.domain.name", server.getDomainName());
        this.properties.put("payara.domain.installroot", serverCtx.getInstallRoot().getAbsolutePath());
        this.properties.put("payara.config.dir", server.getConfigDirPath().getAbsolutePath());
        this.properties.put("payara.instance.starttime", Long.toString(server.getStartupContext().getCreationTime()));
        this.properties.put("payara.instance.config.name", serverCtx.getConfigBean().getConfig().getName());
        this.properties.put("payara.instance.admin.port", Integer.toString(serverCtx.getConfigBean().getAdminPort()));
        this.properties.put("payara.instance.admin.host", serverCtx.getConfigBean().getAdminHost());
        NetworkListener listener = serverCtx.getConfigBean().getConfig().getNetworkConfig().getNetworkListener("http-listener-1");
        if (listener == null) {
            listener = serverCtx.getConfigBean().getConfig().getNetworkConfig().getNetworkListener("http-listener");
        }
        if (listener != null) {
            this.properties.put("payara.instance.http.port", listener.getPort());
            this.properties.put("payara.instance.http.address", listener.getAddress());
            this.properties.put("payara.instance.http.enabled", listener.getEnabled());
        }
        if ((listener = serverCtx.getConfigBean().getConfig().getNetworkConfig().getNetworkListener("http-listener-2")) == null) {
            listener = serverCtx.getConfigBean().getConfig().getNetworkConfig().getNetworkListener("https-listener");
        }
        if (listener != null) {
            this.properties.put("payara.instance.https.port", listener.getPort());
            this.properties.put("payara.instance.https.address", listener.getAddress());
            this.properties.put("payara.instance.https.enabled", listener.getEnabled());
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public int getOrdinal() {
        String ordinalVal = this.properties.getOrDefault("config_ordinal", "1000");
        return Integer.parseInt(ordinalVal);
    }

    public String getValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    public String getName() {
        return "Payara";
    }
}

