/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;

public class SystemPropertyConfigSource
extends PayaraConfigSource {
    private ServerContext context;

    public SystemPropertyConfigSource() {
        this.context = Globals.getDefaultHabitat().getService(ServerContext.class, new Annotation[0]);
    }

    SystemPropertyConfigSource(boolean test) {
        super(test);
    }

    public Map<String, String> getProperties() {
        Properties props = System.getProperties();
        HashMap<String, String> result = new HashMap<String, String>(props.size());
        for (String propertyName : props.stringPropertyNames()) {
            result.put(propertyName, props.getProperty(propertyName));
        }
        return result;
    }

    public int getOrdinal() {
        String storedOrdinal = this.getValue("config_ordinal");
        if (storedOrdinal != null) {
            return Integer.parseInt(storedOrdinal);
        }
        return 400;
    }

    public String getValue(String propertyName) {
        String result = System.getProperty(propertyName);
        if (result == null && this.context != null && (result = this.context.getConfigBean().getSystemPropertyValue(propertyName)) == null) {
            result = this.domainConfiguration.getSystemPropertyValue(propertyName);
        }
        return result;
    }

    public String getName() {
        return "SystemProperty";
    }
}

