/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import com.sun.common.util.logging.LoggingConfig;
import com.sun.common.util.logging.LoggingConfigImpl;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class LoggingConfigFactory
implements Factory<LoggingConfig> {
    private static final Logger LOGGER = Logger.getLogger(LoggingConfigFactory.class.getName());
    @Inject
    private ServiceLocator locator;
    private final Map<String, LoggingConfig> configs = new HashMap<String, LoggingConfig>();

    public void dispose(LoggingConfig config) {
        if (config == null) {
            return;
        }
        Iterator<Map.Entry<String, LoggingConfig>> configIterator = this.configs.entrySet().iterator();
        while (configIterator.hasNext()) {
            Map.Entry<String, LoggingConfig> configEntry = configIterator.next();
            if (!configEntry.getValue().equals(config)) continue;
            configIterator.remove();
        }
    }

    public LoggingConfig provide(String target) {
        LoggingConfig config = this.configs.get(target);
        if (config != null) {
            return config;
        }
        config = (LoggingConfig)this.locator.createAndInitialize(LoggingConfigImpl.class);
        try {
            config.initialize(target);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "An error occurred while reading from the logs for the target '" + target + "'.", ex);
            return null;
        }
        this.configs.put(target, config);
        return config;
    }

    public LoggingConfig provide() {
        return this.provide(null);
    }
}

