/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.util.ArrayList;

public final class ExceptionUtil {
    private static final String DS_FAILURE_MESSAGE = "java.sql.SQLException: Error in allocating a connection. Cause: Connection could not be allocated";

    private ExceptionUtil() {
    }

    public static Throwable[] getCauses(Throwable start) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        boolean haveNonException = false;
        Throwable t = start;
        while (t != null) {
            Throwable temp;
            list.add(t);
            if (!(t instanceof Exception)) {
                haveNonException = true;
            }
            if ((temp = t.getCause()) == null) break;
            t = temp;
        }
        Throwable[] results = haveNonException ? new Throwable[list.size()] : new Exception[list.size()];
        list.toArray(results);
        return results;
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable[] causes = ExceptionUtil.getCauses(e);
        return causes[causes.length - 1];
    }

    public static String getStackTrace(Throwable t) {
        StackTraceElement[] elems;
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement elem : elems = t.getStackTrace()) {
            buf.append(elem);
            buf.append("\n");
        }
        return buf.toString();
    }

    public static boolean isDSFailure(Exception ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (cause.getMessage() == null || !cause.getMessage().contains(DS_FAILURE_MESSAGE)) continue;
            return true;
        }
        return false;
    }
}

