/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.StringUtils;
import java.util.Optional;

public final class JDK {
    private static int major;
    private static int minor;
    private static int subminor;
    private static int update;
    private static String vendor;
    private static String vm;
    private static Version JDK_VERSION;

    public static boolean isRunningLTSJDK() {
        int major = JDK.getMajor();
        return (major - 17) % 4 == 0 && major >= 17 || major == 11;
    }

    public static boolean ok() {
        return major >= 11;
    }

    public static int getMajor() {
        return major;
    }

    public static int getMinor() {
        return minor;
    }

    public static int getSubMinor() {
        return subminor;
    }

    public static int getUpdate() {
        return update;
    }

    public static String getVendor() {
        return vendor;
    }

    public static String getVm() {
        return vm;
    }

    public static Version getVersion(String string) {
        if (string != null && string.matches("([0-9]+[\\._u\\-]+)*[0-9]+")) {
            return new Version(string);
        }
        return null;
    }

    public static Version getVersion() {
        return new Version();
    }

    public static boolean isCorrectJDK(Optional<Version> minVersion, Optional<Version> maxVersion) {
        return JDK.isCorrectJDK(Optional.of(JDK_VERSION), minVersion, maxVersion);
    }

    public static boolean isCorrectJDK(Optional<Version> reference, Optional<Version> minVersion, Optional<Version> maxVersion) {
        return JDK.isCorrectJDK(reference, Optional.empty(), minVersion, maxVersion);
    }

    public static boolean isCorrectJDK(Optional<Version> reference, Optional<String> vendorOrVM, Optional<Version> minVersion, Optional<Version> maxVersion) {
        Version version = reference.orElse(JDK_VERSION);
        boolean correctJDK = true;
        if (vendorOrVM.isPresent()) {
            boolean bl = correctJDK = vendor.contains(vendorOrVM.get()) || vm.contains(vendorOrVM.get());
        }
        if (correctJDK && minVersion.isPresent()) {
            correctJDK = version.newerOrEquals(minVersion.get());
        }
        if (correctJDK && maxVersion.isPresent()) {
            correctJDK = version.olderOrEquals(maxVersion.get());
        }
        return correctJDK;
    }

    public static String toStringStatic() {
        return "major: " + JDK.getMajor() + "\nminor: " + JDK.getMinor() + "\nsubminor: " + JDK.getSubMinor() + "\nupdate: " + JDK.getUpdate() + "\nOK ==>" + JDK.ok();
    }

    private static void initialize() {
        major = 1;
        update = 0;
        subminor = 0;
        minor = 0;
        try {
            String javaVersion = System.getProperty("java.version");
            vendor = System.getProperty("java.vendor");
            vm = System.getProperty("java.vm.name");
            String javaSpecificationVersion = System.getProperty("java.specification.version");
            String[] jsvSplit = javaSpecificationVersion.split("\\.");
            if (jsvSplit.length == 1) {
                String[] jvSplit = javaVersion.split("-");
                String jvReal = jvSplit[0];
                String[] split = jvReal.split("[\\.]+");
                if (split.length > 0) {
                    if (split.length > 0) {
                        major = Integer.parseInt(split[0]);
                    }
                    if (split.length > 1) {
                        minor = Integer.parseInt(split[1]);
                    }
                    if (split.length > 2) {
                        subminor = Integer.parseInt(split[2]);
                    }
                    if (split.length > 3) {
                        update = Integer.parseInt(split[3]);
                    }
                }
            } else {
                if (!StringUtils.ok(javaVersion)) {
                    return;
                }
                String[] ss = javaVersion.split("\\.");
                if (ss.length < 3 || !ss[0].equals("1")) {
                    return;
                }
                major = Integer.parseInt(ss[0]);
                minor = Integer.parseInt(ss[1]);
                if ((ss = ss[2].split("_")).length < 1) {
                    return;
                }
                subminor = Integer.parseInt(ss[0]);
                if (ss.length > 1) {
                    update = Integer.parseInt(ss[1]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDK_VERSION = new Version();
    }

    static {
        JDK.initialize();
    }

    public static class Version {
        private final int major;
        private final Optional<Integer> minor;
        private final Optional<Integer> subminor;
        private final Optional<Integer> update;

        private Version(String version) {
            String[] split;
            if (version.contains("-")) {
                String[] versionSplit = version.split("-");
                version = versionSplit.length > 1 ? versionSplit[1] : "";
            }
            this.major = (split = version.split("[\\._u\\-]+")).length > 0 ? Integer.parseInt(split[0]) : 0;
            this.minor = split.length > 1 ? Optional.of(Integer.parseInt(split[1])) : Optional.empty();
            this.subminor = split.length > 2 ? Optional.of(Integer.parseInt(split[2])) : Optional.empty();
            this.update = split.length > 3 ? Optional.of(Integer.parseInt(split[3])) : Optional.empty();
        }

        private Version() {
            this.major = major;
            this.minor = Optional.of(minor);
            this.subminor = Optional.of(subminor);
            this.update = Optional.of(update);
        }

        public boolean newerThan(Version version) {
            if (this.major > version.major) {
                return true;
            }
            if (this.major == version.major) {
                if (Version.greaterThan(this.minor, version.minor)) {
                    return true;
                }
                if (Version.equals(this.minor, version.minor)) {
                    if (Version.greaterThan(this.subminor, version.subminor)) {
                        return true;
                    }
                    if (Version.equals(this.subminor, version.subminor) && Version.greaterThan(this.update, version.update)) {
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean olderThan(Version version) {
            if (this.major < version.major) {
                return true;
            }
            if (this.major == version.major) {
                if (Version.lessThan(this.minor, version.minor)) {
                    return true;
                }
                if (Version.equals(this.minor, version.minor)) {
                    if (Version.lessThan(this.subminor, version.subminor)) {
                        return true;
                    }
                    if (Version.equals(this.subminor, version.subminor) && Version.lessThan(this.update, version.update)) {
                        return true;
                    }
                }
            }
            return false;
        }

        private static boolean greaterThan(Optional<Integer> leftHandSide, Optional<Integer> rightHandSide) {
            return leftHandSide.orElse(0) > rightHandSide.orElse(0);
        }

        private static boolean lessThan(Optional<Integer> leftHandSide, Optional<Integer> rightHandSide) {
            return leftHandSide.orElse(0) < rightHandSide.orElse(0);
        }

        private static boolean equals(Optional<Integer> leftHandSide, Optional<Integer> rightHandSide) {
            if (!leftHandSide.isPresent() || !rightHandSide.isPresent()) {
                return true;
            }
            return leftHandSide.orElse(0).equals(rightHandSide.orElse(0));
        }

        public int hashCode() {
            int hash = 3;
            hash = 61 * hash + this.major;
            hash = 61 * hash + this.minor.orElse(0);
            hash = 61 * hash + this.subminor.orElse(0);
            hash = 61 * hash + this.update.orElse(0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (this.major != other.major) {
                return false;
            }
            if (!Version.equals(this.minor, other.minor)) {
                return false;
            }
            if (!Version.equals(this.subminor, other.subminor)) {
                return false;
            }
            return Version.equals(this.update, other.update);
        }

        public boolean newerOrEquals(Version version) {
            return this.newerThan(version) || this.equals(version);
        }

        public boolean olderOrEquals(Version version) {
            return this.olderThan(version) || this.equals(version);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(10);
            sb.append(this.major);
            if (this.minor.isPresent()) {
                sb.append('.').append(this.minor.get());
            }
            if (this.subminor.isPresent()) {
                sb.append('.').append(this.subminor.get());
            }
            if (this.update.isPresent()) {
                sb.append('.').append(this.update.get());
            }
            return sb.toString();
        }
    }
}

