/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.CULoggerInfo;
import com.sun.enterprise.util.LocalStringManager;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalStringManagerImpl
implements LocalStringManager {
    private static final Logger _logger = null;
    private final Class defaultClass;

    public LocalStringManagerImpl(Class defaultClass) {
        this.defaultClass = defaultClass;
    }

    @Override
    public String getLocalString(Class callerClass, String key, String defaultValue) {
        Class stopClass = this.defaultClass.getSuperclass();
        Class startClass = callerClass != null ? callerClass : this.defaultClass;
        ResourceBundle resources = null;
        boolean globalDone = false;
        for (Class c = startClass; c != stopClass && c != null; c = c.getSuperclass()) {
            globalDone = c == this.defaultClass;
            try {
                String baseName = c.getName().substring(0, c.getName().lastIndexOf(".")) + ".LocalStrings";
                resources = ResourceBundle.getBundle(baseName, Locale.getDefault(), c.getClassLoader());
                if (resources == null) continue;
                return resources.getString(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!globalDone) {
            return this.getLocalString(null, key, defaultValue);
        }
        CULoggerInfo.getLogger().log(Level.FINE, "No local string for", key);
        return defaultValue;
    }

    @Override
    public String getLocalString(String key, String defaultValue) {
        return this.getLocalString(null, key, defaultValue);
    }

    @Override
    public String getLocalString(Class callerClass, String key, String defaultFormat, Object ... arguments) {
        MessageFormat f = new MessageFormat(this.getLocalString(callerClass, key, defaultFormat));
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) {
                arguments[i] = "null";
                continue;
            }
            if (arguments[i] instanceof String || arguments[i] instanceof Number || arguments[i] instanceof Date) continue;
            arguments[i] = arguments[i].toString();
        }
        return f.format(arguments);
    }

    public String getLocalString(String key, String defaultFormat, Object ... arguments) {
        return this.getLocalString(null, key, defaultFormat, arguments);
    }
}

