/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InstanceCounter {
    private static final ConcurrentMap<Class<?>, Count> INSTANCE_COUNT = new ConcurrentHashMap();

    public InstanceCounter(Object counted) {
        INSTANCE_COUNT.compute(counted.getClass(), (clazz, value) -> {
            Count count;
            if (value == null) {
                count = new Count();
            } else {
                count = value;
                ++count.instanceCount;
            }
            count.references.add(new WeakReference<Object>(counted, count.referenceQueue));
            return count;
        });
    }

    public static int getInstanceCount(Class<?> countedType, long timeout) {
        INSTANCE_COUNT.compute(countedType, (clazz, value) -> {
            if (value == null) {
                return new Count(0);
            }
            try {
                value.instanceCount -= InstanceCounter.countRemovedInstances(value, timeout);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        });
        return ((Count)InstanceCounter.INSTANCE_COUNT.get(countedType)).instanceCount;
    }

    public static Set<WeakReference<?>> getInstances(Class<?> countedType, long timeout) {
        InstanceCounter.getInstanceCount(countedType, timeout);
        return ((Count)InstanceCounter.INSTANCE_COUNT.get(countedType)).references;
    }

    private static int countRemovedInstances(Count count, long timeout) throws InterruptedException {
        int removedInstances = 0;
        Reference<Object> reference = count.referenceQueue.remove(timeout);
        while (reference != null) {
            ++removedInstances;
            reference.clear();
            assert (count.references.remove(reference)) : "non-existent reference";
            reference = count.referenceQueue.poll();
        }
        return removedInstances;
    }

    private static class Count {
        int instanceCount;
        private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
        private final Set<WeakReference<?>> references = Collections.newSetFromMap(new IdentityHashMap());

        public Count() {
            this.instanceCount = 1;
        }

        public Count(int instanceCount) {
            this.instanceCount = instanceCount;
        }
    }
}

