/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.deployment.util;

import java.io.File;

public final class JavaArchiveUtils {
    private JavaArchiveUtils() {
        throw new AssertionError();
    }

    public static boolean hasJavaArchiveExtension(String fileName, boolean processEar) {
        if (fileName == null) {
            return false;
        }
        return fileName.endsWith(".war") || fileName.endsWith(".rar") || fileName.endsWith(".jar") || processEar && fileName.endsWith(".ear");
    }

    public static String removeJavaArchiveExtension(String fileName, boolean processEar) {
        if (JavaArchiveUtils.hasJavaArchiveExtension(fileName, processEar)) {
            return fileName.substring(0, fileName.length() - 4);
        }
        return fileName;
    }

    public static boolean hasWebArchiveExtension(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.endsWith(".war");
    }

    public static boolean hasWebInf(File archive) {
        if (archive == null) {
            return false;
        }
        return new File(archive, "WEB-INF").exists();
    }

    public static boolean hasContextRoot(File archive) {
        if (archive == null) {
            return false;
        }
        return archive.isFile() ? JavaArchiveUtils.hasWebArchiveExtension(archive.getName()) : archive.isDirectory() && JavaArchiveUtils.hasWebInf(archive);
    }
}

