/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.opentracing.cdi;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.interceptor.InvocationContext;
import jakarta.ws.rs.container.ResourceInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.weld.interceptor.WeldInvocationContext;

public class OpenTracingCdiUtils {
    private static final Logger LOG = Logger.getLogger(OpenTracingCdiUtils.class.getName());

    public static <A extends Annotation> A getAnnotation(BeanManager beanManager, Class<A> annotationClass, InvocationContext invocationContext) {
        A annotation = OpenTracingCdiUtils.getInterceptedAnnotation(annotationClass, invocationContext);
        if (annotation == null) {
            annotation = OpenTracingCdiUtils.getAnnotation(beanManager, annotationClass, invocationContext.getMethod().getDeclaringClass(), invocationContext.getMethod());
        }
        return annotation;
    }

    public static <A extends Annotation> A getAnnotation(BeanManager beanManager, Class<A> annotationClass, ResourceInfo resourceInfo) {
        return OpenTracingCdiUtils.getAnnotation(beanManager, annotationClass, resourceInfo.getResourceClass(), resourceInfo.getResourceMethod());
    }

    public static <A extends Annotation> A getAnnotation(BeanManager beanManager, Class<A> annotationClass, Class<?> annotatedClass, Method method) {
        OpenTracingCdiUtils.logGetAnnotation(annotationClass, method);
        Objects.requireNonNull(annotatedClass, "annotatedClass");
        Objects.requireNonNull(method, "method");
        if (method.isAnnotationPresent(annotationClass)) {
            LOG.log(Level.FINER, "Annotation was directly present on the method");
            return method.getAnnotation(annotationClass);
        }
        if (annotatedClass.isAnnotationPresent(annotationClass)) {
            LOG.log(Level.FINER, "Annotation was directly present on the class");
            return annotatedClass.getAnnotation(annotationClass);
        }
        LOG.log(Level.FINER, "Annotation wasn't directly present on the method or class, checking stereotypes");
        LinkedList<Annotation> annotations = new LinkedList<Annotation>(Arrays.asList(annotatedClass.getAnnotations()));
        Annotation annotation = null;
        while (!annotations.isEmpty()) {
            Annotation a = (Annotation)annotations.remove();
            if (a.annotationType().equals(annotationClass)) {
                LOG.log(Level.FINER, "Annotation was found in a stereotype");
                annotation = (Annotation)annotationClass.cast(a);
                break;
            }
            if (!beanManager.isStereotype(a.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(a.annotationType()));
        }
        return (A)annotation;
    }

    public static <A extends Annotation, T> Optional<T> getConfigOverrideValue(Class<A> annotationClass, String parameterName, InvocationContext invocationContext, Class<T> parameterType) {
        return OpenTracingCdiUtils.getConfigOverrideValue(annotationClass, parameterName, invocationContext.getMethod(), parameterType);
    }

    public static <A extends Annotation, T> Optional<T> getConfigOverrideValue(Class<A> annotationClass, String parameterName, Method method, Class<T> parameterType) {
        Config config = OpenTracingCdiUtils.getConfig();
        if (config == null) {
            LOG.log(Level.FINE, "No config to get override parameters from.");
            return Optional.empty();
        }
        String annotationName = annotationClass.getSimpleName();
        String annotatedMethodName = method.getName();
        String annotatedClassCanonicalName = method.getDeclaringClass().getCanonicalName();
        LOG.log(Level.FINER, "Getting config override for annotated method...");
        Optional methodValue = config.getOptionalValue(annotatedClassCanonicalName + "/" + annotatedMethodName + "/" + annotationName + "/" + parameterName, parameterType);
        if (methodValue.isPresent()) {
            return methodValue;
        }
        LOG.log(Level.FINER, "No config override for annotated method, checking if the method is annotated directly...");
        if (method.getAnnotation(annotationClass) != null) {
            LOG.log(Level.FINER, "Using method annotation.");
            return methodValue;
        }
        LOG.log(Level.FINER, "No config override or annotated method, getting config override for the annotated class...");
        Optional classValue = config.getOptionalValue(annotatedClassCanonicalName + "/" + annotationName + "/" + parameterName, parameterType);
        if (classValue.isPresent()) {
            return classValue;
        }
        LOG.log(Level.FINER, "No config override for the annotated class, getting application wide config override...");
        Optional appValue = config.getOptionalValue(annotationName + "/" + parameterName, parameterType);
        if (!appValue.isPresent()) {
            LOG.log(Level.FINER, "No config overrides");
        }
        return appValue;
    }

    public static <A extends Annotation, T> Optional<T> getConfigOverrideValue(Class<A> annotationClass, String parameterName, ResourceInfo resourceInfo, Class<T> parameterType) {
        Config config = OpenTracingCdiUtils.getConfig();
        if (config == null) {
            LOG.log(Level.FINE, "No config to get override parameters from.");
            return Optional.empty();
        }
        LOG.log(Level.FINER, "Getting config override for annotated method...");
        String annotationName = annotationClass.getSimpleName();
        String annotatedMethodName = resourceInfo.getResourceMethod().getName();
        String annotatedClassCanonicalName = resourceInfo.getResourceClass().getCanonicalName();
        Optional methodValue = config.getOptionalValue(annotatedClassCanonicalName + "/" + annotatedMethodName + "/" + annotationName + "/" + parameterName, parameterType);
        if (methodValue.isPresent()) {
            return methodValue;
        }
        LOG.log(Level.FINEST, "No config override for annotated method, checking if the method is annotated directly...");
        if (resourceInfo.getResourceMethod().getAnnotation(annotationClass) != null) {
            LOG.log(Level.FINER, "Using method annotation.");
            return methodValue;
        }
        LOG.log(Level.FINER, "No config override or annotated method, getting config override for the annotated class...");
        Optional classValue = config.getOptionalValue(annotatedClassCanonicalName + "/" + annotationName + "/" + parameterName, parameterType);
        if (classValue.isPresent()) {
            return classValue;
        }
        LOG.log(Level.FINER, "No config override for the annotated class, getting application wide config override...");
        Optional appValue = config.getOptionalValue(annotationName + "/" + parameterName, parameterType);
        if (!appValue.isPresent()) {
            LOG.log(Level.FINER, "No config overrides");
        }
        return appValue;
    }

    private static <A extends Annotation> A getInterceptedAnnotation(Class<A> annotationClass, InvocationContext invocationContext) {
        if (invocationContext instanceof WeldInvocationContext) {
            Set interceptorBindings = ((WeldInvocationContext)invocationContext).getInterceptorBindings();
            for (Annotation annotationBound : interceptorBindings) {
                if (!annotationBound.annotationType().equals(annotationClass)) continue;
                return (A)annotationBound;
            }
        }
        return null;
    }

    private static Config getConfig() {
        try {
            return ConfigProvider.getConfig();
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.INFO, "No config could be found", ex);
            return null;
        }
    }

    private static void logGetAnnotation(Class<?> annotatedClass, Method method) {
        LOG.log(Level.FINER, "Attempting to get annotation {0} from {1}", new String[]{OpenTracingCdiUtils.getString(annotatedClass, Class::getSimpleName), OpenTracingCdiUtils.getString(method, Method::getName)});
    }

    private static <T> String getString(T object, Function<T, String> toString) {
        if (object == null) {
            return null;
        }
        return toString.apply(object);
    }
}

