/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.micro.services.asadmin;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.appserver.micro.services.PayaraInstanceImpl;
import fish.payara.micro.ClusterCommandResult;
import fish.payara.micro.data.InstanceDescriptor;
import jakarta.inject.Inject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="send-asadmin-command")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="send.asadmin.command")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="send-asadmin-command", description="Sends an asadmin command to an instance")})
public class SendAsadminCommand
implements AdminCommand {
    @Inject
    private PayaraInstanceImpl payaraMicro;
    @Param(name="targets", optional=true)
    private String targets;
    @Param(name="command", optional=false)
    private String command;
    @Param(name="parameters", optional=true, primary=true, multiple=true)
    private String[] parameters;
    @Param(name="explicitTarget", optional=true, multiple=true)
    private String[] explicitTargets;
    @Param(name="verbose", optional=true)
    private boolean verbose;
    @Param(name="logOutput", optional=true)
    private boolean logOutput;

    public void execute(AdminCommandContext context) {
        block22: {
            ActionReport actionReport;
            block20: {
                block21: {
                    actionReport = context.getActionReport();
                    if (!this.payaraMicro.isClustered()) break block20;
                    Map<UUID, InstanceDescriptor> targetInstanceDescriptors = this.getTargetInstanceDescriptors(this.targets);
                    targetInstanceDescriptors.putAll(this.getExplicitTargetInstanceDescriptors(this.explicitTargets));
                    if (targetInstanceDescriptors.isEmpty()) {
                        throw new IllegalArgumentException("No targets match!");
                    }
                    this.parameters = this.parameters != null ? this.parseParameters(this.parameters) : new String[]{""};
                    Map<UUID, Future<ClusterCommandResult>> results = this.payaraMicro.executeClusteredASAdmin(targetInstanceDescriptors.keySet(), this.command, this.parameters);
                    if (results == null) break block21;
                    ArrayList<CallSite> successMessages = new ArrayList<CallSite>();
                    ArrayList warningMessages = new ArrayList();
                    ArrayList<CallSite> failureMessages = new ArrayList<CallSite>();
                    for (Map.Entry<UUID, Future<ClusterCommandResult>> entry : results.entrySet()) {
                        try {
                            ClusterCommandResult clusterCommandResult = entry.getValue().get();
                            switch (clusterCommandResult.getExitStatus()) {
                                case SUCCESS: {
                                    if (!this.verbose && !this.logOutput) break;
                                    String rawOutput = clusterCommandResult.getOutput();
                                    String[] outputComponents = rawOutput.split(clusterCommandResult.getExitStatus().name());
                                    String output = outputComponents.length > 1 ? outputComponents[1] : rawOutput;
                                    String boxedInstanceName = this.boxInstanceName(output);
                                    successMessages.add((CallSite)((Object)("\n" + targetInstanceDescriptors.get(entry.getKey()).getInstanceName() + "\n" + boxedInstanceName)));
                                    break;
                                }
                                case WARNING: {
                                    if (actionReport.getActionExitCode() != ActionReport.ExitCode.FAILURE) {
                                        actionReport.setActionExitCode(ActionReport.ExitCode.WARNING);
                                    }
                                    failureMessages.add((CallSite)((Object)("\n" + targetInstanceDescriptors.get(entry.getKey()).getInstanceName() + ":" + this.processException(clusterCommandResult))));
                                    break;
                                }
                                case FAILURE: {
                                    actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                    failureMessages.add((CallSite)((Object)("\n" + targetInstanceDescriptors.get(entry.getKey()).getInstanceName() + ":\n" + this.processException(clusterCommandResult))));
                                }
                            }
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                            actionReport.failure(Logger.getLogger(SendAsadminCommand.class.getName()), "Ran into an exception during execution: \n", (Throwable)exception);
                        }
                    }
                    switch (actionReport.getActionExitCode()) {
                        case SUCCESS: {
                            actionReport.setMessage("Command executed successfully");
                            if (!this.verbose && !this.logOutput) break;
                            Object output = "";
                            for (String string : successMessages) {
                                output = (String)output + "\n" + string;
                            }
                            if (this.verbose) {
                                actionReport.setMessage((String)output);
                            }
                            if (this.logOutput) {
                                Logger.getLogger(SendAsadminCommand.class.getName()).log(Level.INFO, (String)output);
                                break;
                            }
                            break block22;
                        }
                        case WARNING: {
                            actionReport.setMessage("Command completed with warnings: ");
                            for (String string : warningMessages) {
                                actionReport.appendMessage("\n" + string);
                            }
                            break block22;
                        }
                        case FAILURE: {
                            actionReport.setMessage("Failures reported: ");
                            for (String string : failureMessages) {
                                actionReport.appendMessage("\n" + string);
                            }
                            break;
                        }
                    }
                    break block22;
                }
                actionReport.setMessage("No results returned!");
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                break block22;
            }
            actionReport.setMessage("Hazelcast not enabled");
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private String boxInstanceName(String instanceName) {
        int i;
        Object paddedInstanceName = "";
        int boxSize = instanceName.length() + 6;
        for (i = 0; i < boxSize; ++i) {
            paddedInstanceName = i == 0 || i == boxSize - 1 ? (String)paddedInstanceName + "+" : (String)paddedInstanceName + "=";
        }
        paddedInstanceName = (String)paddedInstanceName + "\n";
        paddedInstanceName = (String)paddedInstanceName + "|  ";
        paddedInstanceName = (String)paddedInstanceName + instanceName;
        paddedInstanceName = (String)paddedInstanceName + "  |";
        paddedInstanceName = (String)paddedInstanceName + "\n";
        for (i = 0; i < boxSize; ++i) {
            paddedInstanceName = i == 0 || i == boxSize - 1 ? (String)paddedInstanceName + "+" : (String)paddedInstanceName + "=";
        }
        return paddedInstanceName;
    }

    private String processException(ClusterCommandResult commandResult) {
        String msg = commandResult.getOutput();
        String[] msgs = msg.split(commandResult.getExitStatus().name());
        return msgs.length > 1 ? msgs[1] : commandResult.getFailureCause().getMessage();
    }

    private Map<UUID, InstanceDescriptor> getTargetInstanceDescriptors(String targets) {
        HashMap<UUID, InstanceDescriptor> targetInstanceDescriptors;
        block10: {
            Set<InstanceDescriptor> instances;
            block9: {
                targetInstanceDescriptors = new HashMap<UUID, InstanceDescriptor>();
                instances = this.payaraMicro.getClusteredPayaras();
                if (targets == null) break block9;
                String[] splitTargets = targets.split(",");
                block0: for (InstanceDescriptor instance : instances) {
                    for (String target : splitTargets) {
                        if (target.contains(":")) {
                            String[] splitTarget = target.split(":");
                            if (splitTarget.length == 2) {
                                String targetGroup = splitTarget[0];
                                String targetInstance = splitTarget[1];
                                if (targetGroup.equals("*")) {
                                    if (targetInstance.equals("*")) {
                                        if (!instance.isMicroInstance()) continue;
                                        targetInstanceDescriptors.put(instance.getMemberUUID(), instance);
                                        continue;
                                    }
                                    if (!instance.getInstanceName().equalsIgnoreCase(targetInstance) || !instance.isMicroInstance()) continue;
                                    targetInstanceDescriptors.put(instance.getMemberUUID(), instance);
                                    continue block0;
                                }
                                if (targetInstance.equals("*")) {
                                    if (!instance.getInstanceGroup().equalsIgnoreCase(targetGroup) || !instance.isMicroInstance()) continue;
                                    targetInstanceDescriptors.put(instance.getMemberUUID(), instance);
                                    continue block0;
                                }
                                if (!instance.getInstanceGroup().equalsIgnoreCase(targetGroup) || !instance.getInstanceName().equalsIgnoreCase(targetInstance) || !instance.isMicroInstance()) continue;
                                targetInstanceDescriptors.put(instance.getMemberUUID(), instance);
                                continue block0;
                            }
                            throw new IllegalArgumentException("Target contains more than one colon \":\", this is not allowed");
                        }
                        if (target.equals("*")) {
                            if (!instance.isMicroInstance()) continue;
                            targetInstanceDescriptors.put(instance.getMemberUUID(), instance);
                            continue;
                        }
                        if (!instance.getInstanceName().equalsIgnoreCase(target) || !instance.isMicroInstance()) continue;
                        targetInstanceDescriptors.put(instance.getMemberUUID(), instance);
                        continue block0;
                    }
                }
                break block10;
            }
            if (this.explicitTargets != null && this.explicitTargets.length != 0) break block10;
            for (InstanceDescriptor instance : instances) {
                if (!instance.isMicroInstance()) continue;
                targetInstanceDescriptors.put(instance.getMemberUUID(), instance);
            }
        }
        return targetInstanceDescriptors;
    }

    private Map<UUID, InstanceDescriptor> getExplicitTargetInstanceDescriptors(String[] explicitTargets) {
        HashMap<UUID, InstanceDescriptor> targetInstanceDescriptors = new HashMap<UUID, InstanceDescriptor>();
        if (explicitTargets == null) {
            return targetInstanceDescriptors;
        }
        Set<InstanceDescriptor> instances = this.payaraMicro.getClusteredPayaras();
        block0: for (String explicitTarget : explicitTargets) {
            String[] explicitTargetComponents = explicitTarget.split(":");
            if (explicitTargetComponents.length == 3) {
                String host = explicitTargetComponents[0];
                String portNumber = explicitTargetComponents[1];
                String instanceName = explicitTargetComponents[2];
                for (InstanceDescriptor instance : instances) {
                    if (!instance.getHostName().getHostName().equals(host) && !instance.getHostName().getHostAddress().equals(host) || !Integer.toString(instance.getHazelcastPort()).equals(portNumber) || !instance.getInstanceName().equalsIgnoreCase(instanceName)) continue;
                    targetInstanceDescriptors.put(instance.getMemberUUID(), instance);
                    instances.remove(instance);
                    continue block0;
                }
                continue;
            }
            throw new IllegalArgumentException("Explicit target needs to take the form of: hostOrIpAddress:hazelcastPort:instanceName\nMake sure there are exactly 3 colons (\":\")");
        }
        return targetInstanceDescriptors;
    }

    private String[] parseParameters(String[] parameters) {
        String primaryParameter = "";
        ArrayList<Object> parsedParameters = new ArrayList<Object>();
        if (parameters.length == 1 && parameters[0].contains(" ")) {
            parameters = parameters[0].split(" ");
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].contains("=")) {
                if (parameters[i].contains("--")) {
                    parsedParameters.add(parameters[i] + "=" + parameters[i + 1]);
                    ++i;
                    continue;
                }
                if (primaryParameter.equals("")) {
                    primaryParameter = parameters[i];
                    continue;
                }
                throw new IllegalArgumentException("Parameter " + parameters[i] + "was not prepended with \"--\", and a primary parameter has already been identified: " + primaryParameter);
            }
            parsedParameters.add(parameters[i]);
        }
        if (!primaryParameter.equals("")) {
            parameters = new String[parsedParameters.size() + 1];
            parameters = parsedParameters.toArray(parameters);
            parameters[parameters.length - 1] = primaryParameter;
        } else {
            parameters = new String[parsedParameters.size()];
            parameters = parsedParameters.toArray(parameters);
        }
        return parameters;
    }
}

