/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics;

import fish.payara.microprofile.metrics.exception.NoSuchRegistryException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jvnet.hk2.annotations.Contract;

@Contract
public interface MetricsService {
    public boolean isEnabled();

    public void refresh();

    public Set<String> getContextNames();

    public MetricsContext getContext(boolean var1);

    public MetricsContext getContext(String var1);

    public static interface MetricsContext {
        public static final String SERVER_CONTEXT_NAME = "";

        public String getName();

        default public boolean isServerContext() {
            return SERVER_CONTEXT_NAME.equals(this.getName());
        }

        public MetricRegistry getOrCreateRegistry(String var1) throws NoSuchRegistryException;

        default public MetricRegistry getBaseRegistry() {
            return this.getOrCreateRegistry("base");
        }

        default public MetricRegistry getVendorRegistry() {
            return this.getOrCreateRegistry("vendor");
        }

        default public MetricRegistry getApplicationRegistry() throws NoSuchRegistryException {
            return this.getOrCreateRegistry("application");
        }

        public ConcurrentMap<String, MetricRegistry> getRegistries();
    }
}

