/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi.producer;

import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.microprofile.metrics.cdi.AnnotationReader;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.glassfish.internal.api.Globals;

@Dependent
public class MetricProducer {
    private static final AnnotationReader<Metric> COUNTER = AnnotationReader.METRIC.asType(Counter.class.getTypeName());
    private static final AnnotationReader<Metric> GAUGE = AnnotationReader.METRIC.asType(Gauge.class.getTypeName());
    private static final AnnotationReader<Metric> HISTOGRAM = AnnotationReader.METRIC.asType(Histogram.class.getTypeName());
    private static final AnnotationReader<Metric> TIMER = AnnotationReader.METRIC.asType(Timer.class.getTypeName());

    @Produces
    private Counter counter(InjectionPoint ip) {
        return COUNTER.getOrRegister(ip, Counter.class, this.getMetricRegistry(ip));
    }

    @Produces
    private <T extends Number> Gauge<T> gauge(InjectionPoint ip) {
        return GAUGE.getOrRegister(ip, Gauge.class, this.getMetricRegistry(ip));
    }

    @Produces
    private Histogram histogram(InjectionPoint ip) {
        return HISTOGRAM.getOrRegister(ip, Histogram.class, this.getMetricRegistry(ip));
    }

    @Produces
    private Timer timer(InjectionPoint ip) {
        return TIMER.getOrRegister(ip, Timer.class, this.getMetricRegistry(ip));
    }

    private MetricRegistry getMetricRegistry(InjectionPoint ip) {
        MetricsService metricsService = (MetricsService)Globals.getDefaultBaseServiceLocator().getService(MetricsService.class, new Annotation[0]);
        for (Annotation an : ip.getAnnotated().getAnnotations()) {
            if (an.annotationType().getName().equals(Metric.class.getTypeName())) {
                Metric a = (Metric)an;
                return metricsService.getContext(true).getOrCreateRegistry(a.scope());
            }
            if (an.annotationType().getName().equals(Counted.class.getTypeName())) {
                Counted a = (Counted)an;
                return metricsService.getContext(true).getOrCreateRegistry(a.scope());
            }
            if (an.annotationType().getName().equals(org.eclipse.microprofile.metrics.annotation.Gauge.class.getTypeName())) {
                org.eclipse.microprofile.metrics.annotation.Gauge a = (org.eclipse.microprofile.metrics.annotation.Gauge)an;
                return metricsService.getContext(true).getOrCreateRegistry(a.scope());
            }
            if (!an.annotationType().getName().equals(Timed.class.getTypeName())) continue;
            Timed a = (Timed)an;
            return metricsService.getContext(true).getOrCreateRegistry(a.scope());
        }
        return metricsService.getContext(true).getApplicationRegistry();
    }
}

