/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi.producer;

import fish.payara.microprofile.metrics.MetricsService;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryScope;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.glassfish.internal.api.Globals;

@ApplicationScoped
public class MetricRegistryProducer {
    private MetricsService metricsService;

    @PostConstruct
    public void init() {
        this.metricsService = (MetricsService)Globals.getDefaultBaseServiceLocator().getService(MetricsService.class, new Annotation[0]);
    }

    @Produces
    @Default
    @RegistryScope
    public MetricRegistry getMetricRegistry(InjectionPoint injectionPoint) {
        RegistryScope registryScope = (RegistryScope)injectionPoint.getAnnotated().getAnnotation(RegistryScope.class);
        if (registryScope == null) {
            return this.getApplicationRegistry();
        }
        String customScope = registryScope.scope();
        return this.getContext().getOrCreateRegistry(customScope);
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.BASE)
    public MetricRegistry getBaseRegistry() {
        return this.getContext().getBaseRegistry();
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    public MetricRegistry getApplicationRegistry() {
        return this.getContext().getApplicationRegistry();
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.VENDOR)
    public MetricRegistry getVendorRegistry() {
        return this.getContext().getVendorRegistry();
    }

    private MetricsService.MetricsContext getContext() {
        return this.metricsService.getContext(true);
    }
}

