/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.healthcheck;

public class ServiceExpression {
    private String service;
    private String attributeName;
    private String subAttributeName;

    public ServiceExpression(String expression) {
        if (expression == null || expression.trim().isEmpty()) {
            throw new IllegalArgumentException("Service Expression is null");
        }
        int slashIndex = expression.lastIndexOf("/");
        if (slashIndex >= 0) {
            this.service = expression.substring(0, slashIndex);
            this.attributeName = expression.substring(slashIndex + 1);
            if (this.attributeName.contains("#")) {
                int hashIndex = this.attributeName.indexOf("#");
                this.subAttributeName = this.attributeName.substring(hashIndex + 1);
                this.attributeName = this.attributeName.substring(0, hashIndex);
            }
        } else {
            slashIndex = expression.lastIndexOf("#");
            if (slashIndex < 0) {
                throw new IllegalArgumentException("Service Expression is invalid : " + expression);
            }
            this.service = expression.substring(0, slashIndex);
            this.subAttributeName = expression.substring(slashIndex + 1);
        }
    }

    public String getServiceId() {
        return this.service;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getSubAttributeName() {
        return this.subAttributeName;
    }
}

