/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.impl.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.metrics.Metric;

abstract class CompleteMinuteMinMaxTracker
implements Metric {
    protected final Clock clock;
    private final AtomicReference<MinMax> currentMinute;
    private volatile MinMax completeMinute;

    public CompleteMinuteMinMaxTracker(Clock clock) {
        this.clock = clock;
        this.currentMinute = new AtomicReference();
        this.completeMinute = null;
    }

    Long getMaxValue() {
        this.currentMinMax(null);
        return this.completeMinute == null ? null : Long.valueOf(this.completeMinute.max.get());
    }

    Long getMinValue() {
        this.currentMinMax(null);
        return this.completeMinute == null ? null : Long.valueOf(this.completeMinute.min.get());
    }

    void updateMaxValue(long currentValue) {
        this.currentMinMax(currentValue).updateMax(currentValue);
    }

    void updateMinValue(long currentValue) {
        this.currentMinMax(currentValue).updateMin(currentValue);
    }

    void updateValue(long currentValue) {
        MinMax stats = this.currentMinMax(currentValue);
        stats.updateMin(currentValue);
        stats.updateMax(currentValue);
    }

    private long currentEpochMinute() {
        return Instant.ofEpochMilli(this.clock.getTime()).truncatedTo(ChronoUnit.MINUTES).getEpochSecond() / 60L;
    }

    private MinMax currentMinMax(Long currentValue) {
        long currentEpochMinute = this.currentEpochMinute();
        MinMax possiblyOutdated = this.currentMinute.getAndUpdate(value -> value == null || value.markIfOld(currentEpochMinute) ? (currentValue == null ? null : new MinMax(currentValue, currentEpochMinute)) : value);
        if (possiblyOutdated != null && possiblyOutdated.finished.get()) {
            this.completeMinute = possiblyOutdated;
            return this.currentMinute.get();
        }
        if (this.completeMinute != null && currentEpochMinute - 1L > this.completeMinute.epochMinute) {
            this.completeMinute = null;
        }
        return possiblyOutdated != null ? possiblyOutdated : this.currentMinute.get();
    }

    private static final class MinMax {
        final AtomicLong min;
        final AtomicLong max;
        final long epochMinute;
        final AtomicBoolean finished = new AtomicBoolean(false);

        MinMax(long initialValue, long currentEpochMinute) {
            this.min = new AtomicLong(initialValue);
            this.max = new AtomicLong(initialValue);
            this.epochMinute = currentEpochMinute;
        }

        boolean markIfOld(long currentEpochMinute) {
            return currentEpochMinute > this.epochMinute && this.finished.compareAndSet(false, true);
        }

        void updateMin(long value) {
            this.min.accumulateAndGet(value, Math::min);
        }

        void updateMax(long value) {
            this.max.accumulateAndGet(value, Math::max);
        }
    }
}

