/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import jakarta.enterprise.inject.Vetoed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Gauge;

@Vetoed
public class GaugeImpl<T extends Number>
implements Gauge<T>,
Supplier<T> {
    private final Method method;
    private final Object target;

    public GaugeImpl() {
        this.method = null;
        this.target = null;
    }

    public GaugeImpl(Method method, Object target) {
        this.method = method;
        this.target = target;
        method.setAccessible(true);
    }

    @Override
    public T get() {
        return this.getValue();
    }

    @Override
    public T getValue() {
        return this.invokeMethod(this.method, this.target);
    }

    private T invokeMethod(Method method, Object target) {
        try {
            return (T)((Number)method.invoke(target, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException cause) {
            throw new IllegalStateException("Error while invoking method [" + method + "]", cause);
        }
    }

    public String toString() {
        return "Gauge[" + this.getValue() + "]";
    }
}

