/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.impl.ConfigurationProperties;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.microprofile.metrics.Snapshot;

public class WeightedSnapshot
extends Snapshot {
    private final long[] values;
    private final double[] normWeights;
    private final double[] quantiles;
    private ConfigurationProperties configurationProperties;

    public WeightedSnapshot(Collection<WeightedSample> values, ConfigurationProperties configurationProperties) {
        this(values);
        this.configurationProperties = configurationProperties;
    }

    public WeightedSnapshot(Collection<WeightedSample> values) {
        int i;
        WeightedSample[] copy = values.toArray(new WeightedSample[0]);
        Arrays.sort(copy, Comparator.comparing(w -> w.value));
        this.values = new long[copy.length];
        this.normWeights = new double[copy.length];
        this.quantiles = new double[copy.length];
        double sumWeight = 0.0;
        for (WeightedSample sample : copy) {
            sumWeight += sample.weight;
        }
        for (i = 0; i < copy.length; ++i) {
            this.values[i] = copy[i].value;
            this.normWeights[i] = sumWeight == 0.0 ? 0.0 : copy[i].weight / sumWeight;
        }
        for (i = 1; i < copy.length; ++i) {
            this.quantiles[i] = this.quantiles[i - 1] + this.normWeights[i - 1];
        }
    }

    @Override
    public long size() {
        return this.values.length;
    }

    @Override
    public double getMax() {
        if (this.values.length == 0) {
            return 0.0;
        }
        return this.values[this.values.length - 1];
    }

    @Override
    public double getMean() {
        if (this.values.length == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            sum += (double)this.values[i] * this.normWeights[i];
        }
        return sum;
    }

    @Override
    public Snapshot.PercentileValue[] percentileValues() {
        Snapshot.PercentileValue[] percentileValues = null;
        if (this.configurationProperties != null) {
            Double[] percentiles = this.configurationProperties.percentileValues();
            percentileValues = new Snapshot.PercentileValue[percentiles.length];
            for (int i = 0; i < percentiles.length; ++i) {
                percentileValues[i] = new Snapshot.PercentileValue(percentiles[i], this.getValue(percentiles[i]));
            }
        } else {
            double[] percentiles = new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999};
            if (this.values.length > 0 && this.quantiles.length > 0 && this.values.length == this.quantiles.length) {
                percentileValues = new Snapshot.PercentileValue[percentiles.length];
                for (int i = 0; i < percentiles.length; ++i) {
                    percentileValues[i] = new Snapshot.PercentileValue(percentiles[i], this.getValue(percentiles[i]));
                }
            } else {
                percentileValues = new Snapshot.PercentileValue[percentiles.length];
                for (int i = 0; i < percentiles.length; ++i) {
                    percentileValues[i] = new Snapshot.PercentileValue(percentiles[i], 0.0);
                }
            }
        }
        return percentileValues;
    }

    @Override
    public Snapshot.HistogramBucket[] bucketValues() {
        Double[] buckets = this.configurationProperties.bucketValues();
        Snapshot.HistogramBucket[] histogramBuckets = new Snapshot.HistogramBucket[buckets.length];
        for (int i = 0; i < buckets.length; ++i) {
            histogramBuckets[i] = new Snapshot.HistogramBucket(buckets[i], i);
        }
        return histogramBuckets;
    }

    private double getValue(double quantile) {
        if (quantile < 0.0 || quantile > 1.0 || Double.isNaN(quantile)) {
            throw new IllegalArgumentException(quantile + " is not in [0..1]");
        }
        if (this.values.length == 0) {
            return 0.0;
        }
        int posx = Arrays.binarySearch(this.quantiles, quantile);
        if (posx < 0) {
            posx = -posx - 1 - 1;
        }
        if (posx < 1) {
            return this.values[0];
        }
        if (posx >= this.values.length) {
            return this.values[this.values.length - 1];
        }
        return this.values[posx];
    }

    @Override
    public void dump(OutputStream output) {
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
            for (long value : this.values) {
                out.printf("%d%n", value);
            }
        }
    }

    public ConfigurationProperties getConfigAdapter() {
        return this.configurationProperties;
    }

    public String toString() {
        return "Snapshot[" + this.size() + "]";
    }

    public static class WeightedSample {
        public final long value;
        public final double weight;

        public WeightedSample(long value, double weight) {
            this.value = value;
            this.weight = weight;
        }
    }
}

