/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.jmx;

import fish.payara.microprofile.metrics.healthcheck.HealthCheckCounter;
import fish.payara.microprofile.metrics.healthcheck.HealthCheckGauge;
import fish.payara.microprofile.metrics.healthcheck.ServiceExpression;
import fish.payara.microprofile.metrics.impl.MetricRegistryImpl;
import fish.payara.microprofile.metrics.jmx.MBeanCounterImpl;
import fish.payara.microprofile.metrics.jmx.MBeanExpression;
import fish.payara.microprofile.metrics.jmx.MBeanGuageImpl;
import fish.payara.microprofile.metrics.jmx.MetricsMetadata;
import fish.payara.microprofile.metrics.jmx.XmlTag;
import fish.payara.nucleus.healthcheck.HealthCheckStatsProvider;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class MetricsMetadataHelper {
    public static final String SPECIFIER = "%s";
    public static final String KEY = "${key}";
    public static final String ATTRIBUTE = "${attribute}";
    public static final String SUB_ATTRIBUTE = "${subattribute}";
    public static final String ATTRIBUTE_SEPARATOR = "/";
    public static final String SUB_ATTRIBUTE_SEPARATOR = "#";
    public static final String INSTANCE = "${instance}";
    public static final String GAUGE_METRIC_MBEAN_NAME = "gauge";
    public static final String COUNTER_METRIC_MBEAN_NAME = "counter";
    private static final Logger LOGGER = Logger.getLogger(MetricsMetadataHelper.class.getName());
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ServiceLocator habitat;

    public List<MetricsMetadata> registerMetadata(MetricRegistry metricRegistry, List<MetricsMetadata> metadataList, boolean isRetry) {
        if (!metricRegistry.getNames().isEmpty() && !isRetry) {
            metricRegistry.removeMatching(MetricFilter.ALL);
        }
        List<MetricsMetadata> unresolvedMetadataList = this.resolveDynamicMetadata(metadataList);
        for (MetricsMetadata beanMetadata : metadataList) {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (XmlTag tag : beanMetadata.getTags()) {
                tags.add(new Tag(tag.getName(), tag.getValue()));
            }
            try {
                Metric type;
                if (metricRegistry.getNames().contains(beanMetadata.getName()) && metricRegistry.getMetricIDs().contains(new MetricID(beanMetadata.getName(), tags.toArray(new Tag[tags.size()])))) continue;
                if (beanMetadata.getMBean() != null) {
                    MBeanExpression mBeanExpression = new MBeanExpression(beanMetadata.getMBean());
                    switch (beanMetadata.getType()) {
                        case "counter": {
                            type = new MBeanCounterImpl(mBeanExpression);
                            break;
                        }
                        case "gauge": {
                            type = new MBeanGuageImpl(mBeanExpression);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported type : " + beanMetadata);
                        }
                    }
                    if (!(metricRegistry instanceof MetricRegistryImpl)) continue;
                    ((MetricRegistryImpl)metricRegistry).register((Metadata)beanMetadata, this.getInterfaceType(beanMetadata.getType()), type, tags.toArray(new Tag[tags.size()]));
                    continue;
                }
                ServiceExpression expression = new ServiceExpression(beanMetadata.getService());
                HealthCheckStatsProvider healthCheck = (HealthCheckStatsProvider)this.habitat.getService(HealthCheckStatsProvider.class, expression.getServiceId(), new Annotation[0]);
                if (healthCheck != null) {
                    switch (beanMetadata.getType()) {
                        case "counter": {
                            type = new HealthCheckCounter(healthCheck, expression);
                            metricRegistry.counter(beanMetadata, tags.toArray(new Tag[tags.size()]));
                            break;
                        }
                        case "gauge": {
                            type = new HealthCheckGauge(healthCheck, expression);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported type : " + beanMetadata);
                        }
                    }
                    if (!(metricRegistry instanceof MetricRegistryImpl)) continue;
                    ((MetricRegistryImpl)metricRegistry).register((Metadata)beanMetadata, this.getInterfaceType(beanMetadata.getType()), type, tags.toArray(new Tag[tags.size()]));
                    continue;
                }
                throw new IllegalStateException("Health-Check service not found : " + beanMetadata.getService());
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return unresolvedMetadataList;
    }

    public String getInterfaceType(String type) {
        if (type.equals(COUNTER_METRIC_MBEAN_NAME)) {
            return Counter.class.getTypeName();
        }
        if (type.equals(GAUGE_METRIC_MBEAN_NAME)) {
            return Gauge.class.getTypeName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetricsMetadata> resolveDynamicMetadata(List<MetricsMetadata> metadataList) {
        ArrayList<MetricsMetadata> unresolvedMetadataList = new ArrayList<MetricsMetadata>();
        ArrayList<MetricsMetadata> resolvedMetadataList = new ArrayList<MetricsMetadata>();
        ArrayList<MetricsMetadata> removedMetadataList = new ArrayList<MetricsMetadata>(metadataList.size());
        for (MetricsMetadata metadata : metadataList) {
            if (!metadata.isValid()) {
                removedMetadataList.add(metadata);
                continue;
            }
            if (metadata.getMBean() != null && (metadata.getMBean().contains(SPECIFIER) || metadata.getMBean().contains(KEY) || metadata.getMBean().contains(ATTRIBUTE) || metadata.getMBean().contains(SUB_ATTRIBUTE) || metadata.getMBean().contains(INSTANCE))) {
                try {
                    MBeanExpression mBeanExpression;
                    String instanceName = this.serverEnv.getInstanceName();
                    String queryExpression = metadata.getMBean().replace(INSTANCE, instanceName);
                    if (metadata.getMBean().contains(SPECIFIER) || metadata.getMBean().contains(KEY)) {
                        mBeanExpression = new MBeanExpression(queryExpression.replace(SPECIFIER, "*").replace(KEY, "*"));
                        String dynamicKey = mBeanExpression.findDynamicKey();
                        Set<ObjectName> mBeanObjects = mBeanExpression.queryNames(null);
                        if (mBeanObjects.isEmpty()) {
                            unresolvedMetadataList.add(metadata);
                            LOGGER.log(Level.INFO, "{0} does not correspond to any MBeans", metadata.getMBean());
                        } else if (metadata.isDynamic()) {
                            unresolvedMetadataList.add(metadata);
                        }
                        for (ObjectName objName : mBeanObjects) {
                            String dynamicValue = objName.getKeyPropertyList().get(dynamicKey);
                            resolvedMetadataList.addAll(MetricsMetadataHelper.loadAttribute(objName, mBeanExpression, metadata, dynamicValue, instanceName));
                        }
                        continue;
                    }
                    mBeanExpression = new MBeanExpression(queryExpression);
                    ObjectName objName = mBeanExpression.getObjectName();
                    if (objName == null) {
                        unresolvedMetadataList.add(metadata);
                        LOGGER.log(Level.INFO, "{0} does not correspond to any MBeans", metadata.getMBean());
                    } else if (metadata.isDynamic()) {
                        unresolvedMetadataList.add(metadata);
                    }
                    resolvedMetadataList.addAll(MetricsMetadataHelper.loadAttribute(objName, mBeanExpression, metadata, null, instanceName));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.log(Level.SEVERE, ex, () -> metadata.getMBean() + " is invalid");
                    continue;
                }
                finally {
                    removedMetadataList.add(metadata);
                    continue;
                }
            }
            if (metadata.getService() == null || !metadata.getService().contains(SPECIFIER) && !metadata.getService().contains(ATTRIBUTE) && !metadata.getService().contains(SUB_ATTRIBUTE) && !metadata.getService().contains(INSTANCE)) continue;
            ServiceExpression expression = new ServiceExpression(metadata.getService().replace(SPECIFIER, "*"));
            if (expression.getAttributeName() != null && (expression.getAttributeName().equals("*") || expression.getAttributeName().equals(ATTRIBUTE))) {
                removedMetadataList.add(metadata);
                resolvedMetadataList.addAll(this.loadAttribute(expression, metadata));
                continue;
            }
            if (expression.getSubAttributeName() == null || !expression.getSubAttributeName().equals("*") && !expression.getSubAttributeName().equals(SUB_ATTRIBUTE)) continue;
            removedMetadataList.add(metadata);
            resolvedMetadataList.addAll(this.loadSubAttribute(expression, metadata, expression.getAttributeName()));
        }
        metadataList.removeAll(removedMetadataList);
        metadataList.addAll(resolvedMetadataList);
        return unresolvedMetadataList;
    }

    private List<MetricsMetadata> loadAttribute(ServiceExpression expression, MetricsMetadata metadata) {
        ArrayList<MetricsMetadata> metadataList = new ArrayList<MetricsMetadata>();
        String instanceName = this.serverEnv.getInstanceName();
        HealthCheckStatsProvider healthCheck = (HealthCheckStatsProvider)this.habitat.getService(HealthCheckStatsProvider.class, expression.getServiceId(), new Annotation[0]);
        if (healthCheck != null) {
            for (String attribute : healthCheck.getAttributes()) {
                if (expression.getSubAttributeName() != null && (expression.getSubAttributeName().equals("*") || expression.getSubAttributeName().equals(SUB_ATTRIBUTE))) {
                    metadataList.addAll(this.loadSubAttribute(expression, metadata, attribute));
                    continue;
                }
                metadataList.add(MetricsMetadataHelper.createMetadata(metadata, expression.getServiceId(), null, attribute, expression.getSubAttributeName(), instanceName));
            }
        } else {
            LOGGER.log(Level.WARNING, "Health-Check service not found : {0}", expression.getServiceId());
        }
        return metadataList;
    }

    private List<MetricsMetadata> loadSubAttribute(ServiceExpression expression, MetricsMetadata metadata, String attribute) {
        ArrayList<MetricsMetadata> metadataList = new ArrayList<MetricsMetadata>();
        String instanceName = this.serverEnv.getInstanceName();
        HealthCheckStatsProvider healthCheck = (HealthCheckStatsProvider)this.habitat.getService(HealthCheckStatsProvider.class, expression.getServiceId(), new Annotation[0]);
        if (healthCheck != null) {
            for (String subAttribute : healthCheck.getSubAttributes()) {
                metadataList.add(MetricsMetadataHelper.createMetadata(metadata, expression.getServiceId(), null, attribute, subAttribute, instanceName));
            }
        } else {
            LOGGER.log(Level.WARNING, "Health-Check service not found : {0}", expression.getServiceId());
        }
        return metadataList;
    }

    private static List<MetricsMetadata> loadAttribute(ObjectName objName, MBeanExpression mBeanExpression, MetricsMetadata metadata, String key, String instanceName) {
        ArrayList<MetricsMetadata> metadataList = new ArrayList<MetricsMetadata>();
        if (ATTRIBUTE.equals(mBeanExpression.getAttributeName())) {
            List<MBeanAttributeInfo> attributes = mBeanExpression.queryAttributes(objName);
            for (MBeanAttributeInfo attribute : attributes) {
                String attributeName = attribute.getName();
                metadataList.addAll(MetricsMetadataHelper.loadSubAttribute(objName, mBeanExpression, metadata, key, attributeName, instanceName, true));
            }
        } else {
            String attributeName = mBeanExpression.getAttributeName();
            metadataList.addAll(MetricsMetadataHelper.loadSubAttribute(objName, mBeanExpression, metadata, key, attributeName, instanceName, false));
        }
        return metadataList;
    }

    private static List<MetricsMetadata> loadSubAttribute(ObjectName objName, MBeanExpression mBeanExpression, MetricsMetadata metadata, String key, String attribute, String instanceName, boolean isDynamicAttribute) {
        ArrayList<MetricsMetadata> metadataList = new ArrayList<MetricsMetadata>();
        String exp = objName.getCanonicalName();
        String subAttribute = mBeanExpression.getSubAttributeName();
        if (subAttribute != null) {
            if (SUB_ATTRIBUTE.equals(subAttribute)) {
                Object obj = mBeanExpression.querySubAttributes(objName, attribute);
                if (obj instanceof CompositeDataSupport) {
                    CompositeDataSupport compositeData = (CompositeDataSupport)obj;
                    MetadataBuilder newMetadataBuilder = Metadata.builder(metadata);
                    for (String subAttrResolvedName : compositeData.getCompositeType().keySet()) {
                        subAttribute = subAttrResolvedName;
                        if ("description".equals(subAttribute) && compositeData.get(subAttribute) instanceof String && metadata.description().isPresent()) {
                            newMetadataBuilder = newMetadataBuilder.withDescription((String)compositeData.get(subAttribute));
                            continue;
                        }
                        if ("name".equals(subAttribute) && compositeData.get(subAttribute) instanceof String) {
                            newMetadataBuilder = newMetadataBuilder.withName((String)compositeData.get(subAttribute));
                            continue;
                        }
                        if (!"unit".equals(subAttribute) || !(compositeData.get(subAttribute) instanceof String) || !"none".equals(metadata.unit().orElse("none"))) continue;
                        newMetadataBuilder = newMetadataBuilder.withUnit((String)compositeData.get(subAttribute));
                    }
                    MetricsMetadata newMbeanMetadata = new MetricsMetadata(newMetadataBuilder.build());
                    newMbeanMetadata.addTags(metadata.getTags());
                    metadataList.add(MetricsMetadataHelper.createMetadata(newMbeanMetadata, exp, key, attribute, subAttribute, instanceName));
                }
            } else if (isDynamicAttribute) {
                CompositeDataSupport compositeData;
                Object obj = mBeanExpression.querySubAttributes(objName, attribute);
                if (obj instanceof CompositeDataSupport && (compositeData = (CompositeDataSupport)obj).containsKey(subAttribute) && compositeData.get(subAttribute) instanceof Number) {
                    metadataList.add(MetricsMetadataHelper.createMetadata(metadata, exp, key, attribute, subAttribute, instanceName));
                }
            } else {
                metadataList.add(MetricsMetadataHelper.createMetadata(metadata, exp, key, attribute, subAttribute, instanceName));
            }
        } else {
            metadataList.add(MetricsMetadataHelper.createMetadata(metadata, exp, key, attribute, subAttribute, instanceName));
        }
        return metadataList;
    }

    private static MetricsMetadata createMetadata(MetricsMetadata metadata, String exp, String key, String attribute, String subAttribute, String instanceName) {
        StringBuilder builder = new StringBuilder();
        builder.append(exp);
        builder.append(ATTRIBUTE_SEPARATOR);
        builder.append(attribute);
        if (subAttribute != null) {
            builder.append(SUB_ATTRIBUTE_SEPARATOR);
            builder.append(subAttribute);
        }
        MetricsMetadata newMetaData = new MetricsMetadata(MetricsMetadataHelper.formatMetadata(metadata.getName(), key, attribute, subAttribute, instanceName), MetricsMetadataHelper.formatMetadata(metadata.getName(), key, attribute, subAttribute, instanceName), MetricsMetadataHelper.formatMetadata(metadata.description().isPresent() ? metadata.getDescription() : metadata.getName(), key, attribute, subAttribute, instanceName), metadata.getType(), metadata.unit().orElse(null));
        if (metadata.getMBean() != null) {
            newMetaData.setMBean(builder.toString());
        } else {
            newMetaData.setMBean(null);
            newMetaData.setService(builder.toString());
        }
        for (XmlTag oldTag : metadata.getTags()) {
            XmlTag newTag = new XmlTag();
            newTag.setName(MetricsMetadataHelper.formatMetadata(oldTag.getName(), key, attribute, subAttribute, instanceName));
            newTag.setValue(MetricsMetadataHelper.formatMetadata(oldTag.getValue(), key, attribute, subAttribute, instanceName));
            newMetaData.getTags().add(newTag);
        }
        return newMetaData;
    }

    private static String formatMetadata(String metadata, String dynamicValue, String attributeName, String subAttributeName, String instanceName) {
        if (dynamicValue != null && metadata.contains(SPECIFIER)) {
            metadata = metadata.replace(SPECIFIER, dynamicValue);
        }
        if (dynamicValue != null && metadata.contains(KEY)) {
            metadata = metadata.replace(KEY, dynamicValue);
        }
        if (attributeName != null && metadata.contains(ATTRIBUTE)) {
            metadata = metadata.replace(ATTRIBUTE, attributeName);
        }
        if (subAttributeName != null && metadata.contains(SUB_ATTRIBUTE)) {
            metadata = metadata.replace(SUB_ATTRIBUTE, subAttributeName);
        }
        if (metadata.contains(INSTANCE)) {
            metadata = metadata.replace(INSTANCE, instanceName);
        }
        return metadata;
    }
}

