/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.cpool;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.PoolStatus;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckStatsProvider;
import fish.payara.nucleus.healthcheck.cpool.HealthCheckConnectionPoolExecutionOptions;
import fish.payara.nucleus.healthcheck.cpool.configuration.ConnectionPoolChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.jdbc.util.JdbcResourcesUtil;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-cpool")
@RunLevel(value=10)
public class ConnectionPoolHealthCheck
extends BaseThresholdHealthCheck<HealthCheckConnectionPoolExecutionOptions, ConnectionPoolChecker>
implements MonitoringDataSource,
MonitoringWatchSource,
HealthCheckStatsProvider {
    @Inject
    private Domain domain;
    @Inject
    private Applications applications;
    @Inject
    private PoolManager poolManager;
    private final Map<String, Long> usedConnections = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> freeConnections = new ConcurrentHashMap<String, Long>();
    private static final String USED_CONNECTION = "usedConnection";
    private static final String FREE_CONNECTION = "freeConnection";
    private static final String TOTAL_CONNECTION = "totalConnection";
    private static final Set<String> VALID_SUB_ATTRIBUTES = Set.of("usedConnection", "freeConnection", "totalConnection");

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, ConnectionPoolChecker.class);
    }

    public Object getValue(Class type, String attributeName, String subAttributeName) {
        if (subAttributeName == null) {
            throw new IllegalArgumentException("sub-attribute name is required");
        }
        if (!VALID_SUB_ATTRIBUTES.contains(subAttributeName)) {
            throw new IllegalArgumentException("Invalid sub-attribute name: " + subAttributeName + ", supported sub-attributes are " + VALID_SUB_ATTRIBUTES);
        }
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("attribute type must be number");
        }
        switch (subAttributeName) {
            case "usedConnection": {
                return this.usedConnections.getOrDefault(attributeName, 0L);
            }
            case "freeConnection": {
                return this.freeConnections.getOrDefault(attributeName, 0L);
            }
            case "totalConnection": {
                return this.usedConnections.getOrDefault(attributeName, 0L) + this.freeConnections.getOrDefault(attributeName, 0L);
            }
        }
        return 0L;
    }

    @Override
    public Set<String> getAttributes() {
        return this.getAllJdbcResourcesName().stream().map(PoolInfo::getName).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getSubAttributes() {
        return VALID_SUB_ATTRIBUTES;
    }

    @Override
    public boolean isEnabled() {
        return this.getOptions() != null ? ((HealthCheckConnectionPoolExecutionOptions)this.getOptions()).isEnabled() : false;
    }

    @Override
    public HealthCheckConnectionPoolExecutionOptions constructOptions(ConnectionPoolChecker checker) {
        return new HealthCheckConnectionPoolExecutionOptions(Boolean.valueOf(checker.getEnabled()), Long.parseLong(checker.getTime()), this.asTimeUnit(checker.getUnit()), Boolean.valueOf(checker.getAddToMicroProfileHealth()), checker.getPropertyValue("threshold-critical", "80"), checker.getPropertyValue("threshold-warning", "50"), checker.getPropertyValue("threshold-good", "0"), checker.getPoolName());
    }

    @Override
    protected String getDescription() {
        return "healthcheck.description.connectionPool";
    }

    @Override
    protected HealthCheckResult doCheckInternal() {
        HealthCheckResult result = new HealthCheckResult();
        this.freeConnections.clear();
        this.usedConnections.clear();
        this.consumeAllJdbcResources(this.createConsumer((info, usedPercentage) -> result.add(new HealthCheckResultEntry(this.decideOnStatusWithRatio((double)usedPercentage), info.getName() + " Usage (%): " + new DecimalFormat("#.00").format(usedPercentage)))));
        return result;
    }

    public void collect(MonitoringWatchCollector collector) {
        this.collectUsage(collector, "ns:health @:* PoolUsage", "Connection Pool Usage", 5, false);
    }

    @MonitoringData(ns="health", intervalSeconds=8)
    public void collect(MonitoringDataCollector collector) {
        if (this.options != null && ((HealthCheckConnectionPoolExecutionOptions)this.options).isEnabled()) {
            this.freeConnections.clear();
            this.usedConnections.clear();
            this.consumeAllJdbcResources(this.createConsumer((info, usedPercentage) -> collector.group((CharSequence)info.getName()).collect((CharSequence)"PoolUsage", usedPercentage.longValue())));
        }
    }

    private Consumer<JdbcResource> createConsumer(BiConsumer<PoolInfo, Double> poolUsageConsumer) {
        return resource -> {
            PoolStatus poolStatus;
            ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)resource);
            JdbcConnectionPool pool = JdbcResourcesUtil.createInstance().getJdbcConnectionPoolOfResource(resourceInfo);
            PoolInfo poolInfo = ResourceUtil.getPoolInfo((ResourcePool)pool);
            String name = ((HealthCheckConnectionPoolExecutionOptions)this.getOptions()).getPoolName();
            if ((name == null || name.equals(poolInfo.getName())) && (poolStatus = this.poolManager.getPoolStatus(poolInfo)) != null) {
                long freeConnection;
                long usedConnection = poolStatus.getNumConnUsed();
                long totalConnection = usedConnection + (freeConnection = (long)poolStatus.getNumConnFree());
                if (totalConnection > 0L) {
                    double usedPercentage = 100.0 * (double)usedConnection / (double)totalConnection;
                    poolUsageConsumer.accept(poolInfo, usedPercentage);
                }
                this.freeConnections.put(poolInfo.getName(), freeConnection);
                this.usedConnections.put(poolInfo.getName(), usedConnection);
            }
        };
    }

    private void consumeAllJdbcResources(Consumer<JdbcResource> consumer) {
        ConnectionPoolHealthCheck.consumeJdbcResources(this.domain.getResources(), consumer);
        for (Application app : this.applications.getApplications()) {
            if (!ResourcesUtil.createInstance().isEnabled(app)) continue;
            ConnectionPoolHealthCheck.consumeJdbcResources(app.getResources(), consumer);
            List modules = app.getModule();
            if (modules == null) continue;
            for (Module module : modules) {
                ConnectionPoolHealthCheck.consumeJdbcResources(module.getResources(), consumer);
            }
        }
    }

    private static void consumeJdbcResources(Resources resources, Consumer<JdbcResource> consumer) {
        List list;
        if (resources != null && (list = resources.getResources()) != null) {
            for (Resource r : list) {
                if (!JdbcResource.class.isInstance(r)) continue;
                consumer.accept((JdbcResource)r);
            }
        }
    }

    private List<PoolInfo> getAllJdbcResourcesName() {
        ArrayList<PoolInfo> poolInfos = new ArrayList<PoolInfo>();
        poolInfos.addAll(this.getJdbcResourcesInfo(this.domain.getResources()));
        for (Application app : this.applications.getApplications()) {
            if (!ResourcesUtil.createInstance().isEnabled(app)) continue;
            poolInfos.addAll(this.getJdbcResourcesInfo(app.getResources()));
            List modules = app.getModule();
            if (modules == null) continue;
            for (Module module : modules) {
                poolInfos.addAll(this.getJdbcResourcesInfo(module.getResources()));
            }
        }
        return poolInfos;
    }

    private List<PoolInfo> getJdbcResourcesInfo(Resources resources) {
        List list;
        ArrayList<PoolInfo> poolInfos = new ArrayList<PoolInfo>();
        if (resources != null && (list = resources.getResources()) != null) {
            for (Resource resource : list) {
                if (!JdbcResource.class.isInstance(resource)) continue;
                ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)((JdbcResource)resource));
                JdbcConnectionPool pool = JdbcResourcesUtil.createInstance().getJdbcConnectionPoolOfResource(resourceInfo);
                poolInfos.add(ResourceUtil.getPoolInfo((ResourcePool)pool));
            }
        }
        return poolInfos;
    }
}

