/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.ldap;

import fish.payara.microprofile.config.extensions.ldap.LDAPConfigSourceConfiguration;
import fish.payara.microprofile.config.extensions.ldap.LDAPConfigSourceHelper;
import fish.payara.nucleus.microprofile.config.source.extension.ConfiguredExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.spi.ConfigProviderResolverImpl;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

@Service(name="ldap-config-source")
public class LDAPConfigSource
extends ConfiguredExtensionConfigSource<LDAPConfigSourceConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(LDAPConfigSource.class.getName());
    private LDAPConfigSourceHelper ldapConfigSourceHelper;

    @Override
    public void bootstrap() {
        this.ldapConfigSourceHelper = new LDAPConfigSourceHelper((LDAPConfigSourceConfiguration)this.configuration);
    }

    @Override
    public void destroy() {
        this.ldapConfigSourceHelper = null;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.ldapConfigSourceHelper == null) {
            LDAPConfigSource.printMisconfigurationMessage();
            return new HashMap<String, String>();
        }
        return this.ldapConfigSourceHelper.getAllConfigValues();
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    @Override
    public String getValue(String propertyName) {
        if (this.ldapConfigSourceHelper == null) {
            LDAPConfigSource.printMisconfigurationMessage();
            return null;
        }
        return this.ldapConfigSourceHelper.getConfigValue(propertyName);
    }

    @Override
    public boolean deleteValue(String value) {
        return false;
    }

    @Override
    public boolean setValue(String key, String value) {
        return false;
    }

    @Override
    public String getSource() {
        return "ldap";
    }

    @Override
    public String getName() {
        return "ldap";
    }

    @Override
    public int getOrdinal() {
        return Integer.parseInt(((ConfigProviderResolverImpl)Globals.getDefaultHabitat().getService(ConfigProviderResolverImpl.class, new Annotation[0])).getMPConfig().getLdapOrdinality());
    }

    private static void printMisconfigurationMessage() {
        LOGGER.warning("LDAP Config Source isn't configured correctly.");
    }
}

