/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnectionFactoryImpl;
import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.gjc.spi.base.AbstractDataSource;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConfigProperty;
import jakarta.resource.spi.ConnectionDefinition;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ResourceAllocationException;
import jakarta.resource.spi.security.PasswordCredential;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.sql.DataSource;

@ConnectionDefinition(connectionFactory=DataSource.class, connectionFactoryImpl=AbstractDataSource.class, connection=Connection.class, connectionImpl=ConnectionHolder.class)
public class DMManagedConnectionFactory
extends ManagedConnectionFactoryImpl {
    Properties props;
    private static Logger _logger = LogDomains.getLogger(DMManagedConnectionFactory.class, (String)"javax.enterprise.resource.resourceadapter");
    private boolean debug = _logger.isLoggable(Level.FINE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.logFine("In createManagedConnection");
        if (this.dsObjBuilder == null) {
            this.dsObjBuilder = new DataSourceObjectBuilder(this.spec);
        }
        PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        try {
            Class.forName(this.spec.getDetail(20));
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_cnfe", cnfe);
            throw new ResourceException("The driver could not be loaded: " + this.spec.getDetail(20));
        }
        Connection dsConn = null;
        ManagedConnectionImpl mc = null;
        Properties driverProps = new Properties();
        Hashtable properties = this.dsObjBuilder.parseDriverProperties(this.spec, false);
        Set entries = properties.entrySet();
        for (Map.Entry entry : entries) {
            String value = "";
            String key = (String)entry.getKey();
            Vector values = (Vector)entry.getValue();
            if (!values.isEmpty() && values.size() == 1) {
                value = (String)values.firstElement();
            } else if (values.size() > 1) {
                this.logFine("More than one value for key : " + key);
            }
            String prop = DMManagedConnectionFactory.getParsedKey(key);
            driverProps.put(prop, value);
            if (!prop.equalsIgnoreCase("URL") || this.spec.getDetail(3) != null) continue;
            this.setConnectionURL(value);
        }
        try {
            if (cxRequestInfo != null) {
                driverProps.setProperty("user", pc.getUserName());
                driverProps.setProperty("password", new String(pc.getPassword()));
            } else {
                String user = this.spec.getDetail(1);
                String password = this.spec.getDetail(2);
                if (user != null) {
                    driverProps.setProperty("user", user);
                }
                if (password != null) {
                    driverProps.setProperty("password", password);
                }
            }
            dsConn = DriverManager.getConnection(this.spec.getDetail(3), driverProps);
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_create_mc", sqle);
            throw new ResourceAllocationException("The connection could not be allocated: " + sqle.getMessage());
        }
        try {
            mc = this.constructManagedConnection(null, dsConn, pc, this);
            this.validateAndSetIsolation(mc);
        }
        finally {
            if (mc == null && dsConn != null) {
                try {
                    dsConn.close();
                }
                catch (SQLException e) {
                    _logger.log(Level.FINEST, "Exception while closing connection : createManagedConnection" + dsConn);
                }
            }
        }
        return mc;
    }

    private static String getParsedKey(String key) throws ResourceException {
        String property;
        String string = property = key != null && key.startsWith("set") ? key.substring(3).trim() : key;
        if (property == null || property.isEmpty()) {
            throw new ResourceException("Invalid driver properties string - Key cannot be an empty string");
        }
        return property;
    }

    @Override
    public boolean equals(Object other) {
        this.logFine("In equals");
        if (other instanceof DMManagedConnectionFactory) {
            DMManagedConnectionFactory otherMCF = (DMManagedConnectionFactory)other;
            return this.spec.equals(otherMCF.spec);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 217 + this.spec.hashCode();
    }

    @Override
    public void setLoginTimeOut(String loginTimeOut) {
        block2: {
            int timeOut = 0;
            try {
                timeOut = Integer.parseInt(loginTimeOut);
                DriverManager.setLoginTimeout(timeOut);
                this.spec.setDetail(4, loginTimeOut);
            }
            catch (Exception e) {
                if (!this.debug) break block2;
                _logger.log(Level.FINE, "jdbc.exc_caught_ign", e.getMessage());
            }
        }
    }

    @Override
    @ConfigProperty(type=String.class, defaultValue="org.h2.Driver")
    public void setClassName(String className) {
        this.spec.setDetail(20, className);
    }

    public void setURL(String url) {
        this.spec.setDetail(3, url);
    }

    public String getURL() {
        return this.spec.getDetail(3);
    }

    public void setConnectionURL(String url) {
        this.spec.setDetail(3, url);
    }

    public String getConnectionURL() {
        return this.spec.getDetail(3);
    }

    @Override
    public Object getDataSource() throws ResourceException {
        return null;
    }
}

