/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.config;

import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.glassfish.hk2.classmodel.reflect.Type;

public class OpenApiConfiguration {
    private static final Logger LOGGER = Logger.getLogger(OpenApiConfiguration.class.getName());
    private static final String MODEL_READER_KEY = "mp.openapi.model.reader";
    private static final String FILTER_KEY = "mp.openapi.filter";
    private static final String SCAN_LIB_KEY = "mp.openapi.extensions.scan.lib";
    private static final String SCAN_DISABLE_KEY = "mp.openapi.scan.disable";
    private static final String SCAN_PACKAGES_KEY = "mp.openapi.scan.packages";
    private static final String SCAN_CLASSES_KEY = "mp.openapi.scan.classes";
    private static final String SCAN_EXCLUDE_PACKAGES_KEY = "mp.openapi.scan.exclude.packages";
    private static final String SCAN_EXCLUDE_CLASSES_KEY = "mp.openapi.scan.exclude.classes";
    private static final String SERVERS_KEY = "mp.openapi.servers";
    private static final String PATH_PREFIX_KEY = "mp.openapi.servers.path.";
    private static final String OPERATION_PREFIX_KEY = "mp.openapi.servers.operation.";
    private static final String SCHEMA_DEFINITIONS_PREFIX_KEY = "mp.openapi.schema.";
    private Class<? extends OASModelReader> modelReader;
    private Class<? extends OASFilter> filter;
    private boolean scanDisable = false;
    private boolean scanLib = false;
    private List<String> scanPackages = new ArrayList<String>();
    private List<String> scanClasses = new ArrayList<String>();
    private List<String> scanExcludePackages = new ArrayList<String>();
    private List<String> scanExcludeClasses = new ArrayList<String>();
    private List<String> servers = new ArrayList<String>();
    private Map<String, Set<String>> pathServerMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> operationServerMap = new HashMap<String, Set<String>>();
    private Map<String, SchemaImpl> schemaMap = new HashMap<String, SchemaImpl>();

    public OpenApiConfiguration(ClassLoader applicationClassLoader) {
        if (applicationClassLoader == null) {
            applicationClassLoader = this.getClass().getClassLoader();
        }
        Config config = ConfigProvider.getConfig(applicationClassLoader);
        for (String propertyName : config.getPropertyNames()) {
            this.parseModelReader(propertyName, config);
            this.parseFilter(propertyName, config);
            this.parseScanDisable(propertyName, config);
            this.parseScanLib(propertyName, config);
            this.parseScanPackages(propertyName, config);
            this.parseScanClasses(propertyName, config);
            this.parseExcludePackages(propertyName, config);
            this.parseExcludeClasses(propertyName, config);
            this.parseServers(propertyName, config);
            this.parsePathServer(propertyName, config);
            this.parseOperationServer(propertyName, config);
            this.parseSchema(propertyName, config);
        }
    }

    public Class<? extends OASModelReader> getModelReader() {
        return this.modelReader;
    }

    public Class<? extends OASFilter> getFilter() {
        return this.filter;
    }

    public boolean getScanDisable() {
        return this.scanDisable;
    }

    public boolean getScanLib() {
        return this.scanLib;
    }

    public List<String> getServers() {
        return this.servers;
    }

    public Map<String, Set<String>> getPathServerMap() {
        return this.pathServerMap;
    }

    public Map<String, Set<String>> getOperationServerMap() {
        return this.operationServerMap;
    }

    public Map<String, SchemaImpl> getSchemaMap() {
        return this.schemaMap;
    }

    private void parseModelReader(String propertyName, Config config) {
        if (propertyName.equals(MODEL_READER_KEY)) {
            this.modelReader = OpenApiConfiguration.parseClass(propertyName, config, "Model Reader", OASModelReader.class);
        }
    }

    private void parseFilter(String propertyName, Config config) {
        if (propertyName.equals(FILTER_KEY)) {
            this.filter = OpenApiConfiguration.parseClass(propertyName, config, "Filter", OASFilter.class);
        }
    }

    private void parseScanDisable(String propertyName, Config config) {
        if (propertyName.equals(SCAN_DISABLE_KEY)) {
            this.scanDisable = config.getValue(propertyName, Boolean.class);
        }
    }

    private void parseScanLib(String propertyName, Config config) {
        if (propertyName.equals(SCAN_LIB_KEY)) {
            this.scanLib = config.getValue(propertyName, Boolean.class);
        }
    }

    private void parseScanPackages(String propertyName, Config config) {
        if (propertyName.equals(SCAN_PACKAGES_KEY)) {
            this.scanPackages = OpenApiConfiguration.parseList(propertyName, config);
        }
    }

    private void parseScanClasses(String propertyName, Config config) {
        if (propertyName.equals(SCAN_CLASSES_KEY)) {
            this.scanClasses = OpenApiConfiguration.parseList(propertyName, config);
        }
    }

    private void parseExcludePackages(String propertyName, Config config) {
        if (propertyName.equals(SCAN_EXCLUDE_PACKAGES_KEY)) {
            this.scanExcludePackages = OpenApiConfiguration.parseList(propertyName, config);
        }
    }

    private void parseExcludeClasses(String propertyName, Config config) {
        if (propertyName.equals(SCAN_EXCLUDE_CLASSES_KEY)) {
            this.scanExcludeClasses = OpenApiConfiguration.parseList(propertyName, config);
        }
    }

    private void parseServers(String propertyName, Config config) {
        if (propertyName.equals(SERVERS_KEY)) {
            this.servers = OpenApiConfiguration.parseList(propertyName, config);
        }
    }

    private void parsePathServer(String propertyName, Config config) {
        if (propertyName.startsWith(PATH_PREFIX_KEY)) {
            String pathServer = propertyName.replaceFirst(PATH_PREFIX_KEY, "");
            this.pathServerMap.put(pathServer, OpenApiConfiguration.parseSet(propertyName, config));
        }
    }

    private void parseOperationServer(String propertyName, Config config) {
        if (propertyName.startsWith(OPERATION_PREFIX_KEY)) {
            String operationServer = propertyName.replaceFirst(OPERATION_PREFIX_KEY, "");
            this.operationServerMap.put(operationServer, OpenApiConfiguration.parseSet(propertyName, config));
        }
    }

    private void parseSchema(String propertyName, Config config) {
        if (propertyName.startsWith(SCHEMA_DEFINITIONS_PREFIX_KEY)) {
            String schemaName = propertyName.replaceFirst(SCHEMA_DEFINITIONS_PREFIX_KEY, "");
            this.schemaMap.put(schemaName, config.getValue(propertyName, SchemaImpl.class));
        }
    }

    public Set<Type> getValidClasses(Collection<Type> types) {
        return types.stream().filter(type -> this.checkValidity(type.getName())).collect(Collectors.toSet());
    }

    private boolean checkValidity(String type) {
        if (this.scanExcludeClasses.contains(type)) {
            return false;
        }
        if (this.scanClasses.contains(type)) {
            return true;
        }
        Optional<String> mostSpecificInclude = this.scanPackages.stream().filter(pkg -> type.startsWith((String)pkg)).sorted((p1, p2) -> p2.length() - p1.length()).findFirst();
        Optional<String> mostSpecificExclude = this.scanExcludePackages.stream().filter(pkg -> type.startsWith((String)pkg)).sorted((p1, p2) -> p2.length() - p1.length()).findFirst();
        if (mostSpecificExclude.isPresent() && (!mostSpecificInclude.isPresent() || mostSpecificInclude.get().length() <= mostSpecificExclude.get().length())) {
            return false;
        }
        if (mostSpecificInclude.isPresent()) {
            return true;
        }
        return this.scanClasses.isEmpty() && this.scanPackages.isEmpty();
    }

    private static <T> Class<T> parseClass(String propertyName, Config config, String className, Class<T> clazz) {
        try {
            return config.getValue(propertyName, Class.class);
        }
        catch (NoSuchElementException ex) {
            LOGGER.warning(className + " class not found: " + config.getValue(propertyName, String.class));
        }
        catch (ClassCastException ex) {
            LOGGER.log(Level.WARNING, className + " class was wrong type: " + config.getValue(propertyName, String.class), ex);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to read " + className + " class" + config.getValue(propertyName, String.class), ex);
        }
        return null;
    }

    private static List<String> parseList(String propertyName, Config config) {
        return OpenApiConfiguration.parseCollection(propertyName, config, new ArrayList());
    }

    private static Set<String> parseSet(String propertyName, Config config) {
        return OpenApiConfiguration.parseCollection(propertyName, config, new HashSet());
    }

    private static <C extends Collection<String>> C parseCollection(String propertyName, Config config, C instance) {
        String[] array = config.getValue(propertyName, String[].class);
        if (array != null) {
            for (String item : array) {
                instance.add((String)item.strip());
            }
        }
        return instance;
    }
}

