/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.callbacks.CallbackImpl;
import fish.payara.microprofile.openapi.impl.model.examples.ExampleImpl;
import fish.payara.microprofile.openapi.impl.model.headers.HeaderImpl;
import fish.payara.microprofile.openapi.impl.model.links.LinkImpl;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.model.parameters.ParameterImpl;
import fish.payara.microprofile.openapi.impl.model.parameters.RequestBodyImpl;
import fish.payara.microprofile.openapi.impl.model.responses.APIResponseImpl;
import fish.payara.microprofile.openapi.impl.model.security.SecuritySchemeImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class ComponentsImpl
extends ExtensibleImpl<Components>
implements Components {
    protected Map<String, Schema> schemas = ModelUtils.createOrderedMap();
    protected Map<String, APIResponse> responses = ModelUtils.createOrderedMap();
    protected Map<String, Parameter> parameters = ModelUtils.createOrderedMap();
    protected Map<String, Example> examples = ModelUtils.createOrderedMap();
    protected Map<String, RequestBody> requestBodies = ModelUtils.createOrderedMap();
    protected Map<String, Header> headers = ModelUtils.createOrderedMap();
    protected Map<String, SecurityScheme> securitySchemes = ModelUtils.createOrderedMap();
    protected Map<String, Link> links = ModelUtils.createOrderedMap();
    protected Map<String, Callback> callbacks = ModelUtils.createOrderedMap();

    public static Components createInstance(AnnotationModel annotation, ApiContext context) {
        ComponentsImpl from = new ComponentsImpl();
        from.setExtensions(ComponentsImpl.parseExtensions(annotation));
        ModelUtils.extractAnnotations(annotation, context, "schemas", "name", SchemaImpl::createInstance, (arg_0, arg_1) -> ((Components)from).addSchema(arg_0, arg_1));
        ModelUtils.extractAnnotations(annotation, context, "responses", "name", APIResponseImpl::createInstance, (arg_0, arg_1) -> ((Components)from).addResponse(arg_0, arg_1));
        ModelUtils.extractAnnotations(annotation, context, "parameters", "name", ParameterImpl::createInstance, (arg_0, arg_1) -> ((Components)from).addParameter(arg_0, arg_1));
        ModelUtils.extractAnnotations(annotation, context, "examples", "name", ExampleImpl::createInstance, (arg_0, arg_1) -> ((Components)from).addExample(arg_0, arg_1));
        ModelUtils.extractAnnotations(annotation, context, "requestBodies", "name", RequestBodyImpl::createInstance, (arg_0, arg_1) -> ((Components)from).addRequestBody(arg_0, arg_1));
        ModelUtils.extractAnnotations(annotation, context, "securitySchemes", "securitySchemeName", SecuritySchemeImpl::createInstance, (arg_0, arg_1) -> ((Components)from).addSecurityScheme(arg_0, arg_1));
        ModelUtils.extractAnnotations(annotation, context, "links", "name", LinkImpl::createInstance, (arg_0, arg_1) -> ((Components)from).addLink(arg_0, arg_1));
        ModelUtils.extractAnnotations(annotation, context, "callbacks", "name", CallbackImpl::createInstance, (arg_0, arg_1) -> ((Components)from).addCallback(arg_0, arg_1));
        HeaderImpl.createInstances(annotation, context).forEach((arg_0, arg_1) -> ((Components)from).addHeader(arg_0, arg_1));
        return from;
    }

    public Map<String, Schema> getSchemas() {
        return ModelUtils.readOnlyView(this.schemas);
    }

    public void setSchemas(Map<String, Schema> schemas) {
        this.schemas = ModelUtils.createOrderedMap(schemas);
    }

    public Components addSchema(String key, Schema schema) {
        if (schema != null) {
            if (this.schemas == null) {
                this.schemas = ModelUtils.createOrderedMap();
            }
            this.schemas.put(key, schema);
        }
        return this;
    }

    public void removeSchema(String key) {
        if (this.schemas != null) {
            this.schemas.remove(key);
        }
    }

    public Map<String, APIResponse> getResponses() {
        return ModelUtils.readOnlyView(this.responses);
    }

    public void setResponses(Map<String, APIResponse> responses) {
        this.responses = ModelUtils.createOrderedMap(responses);
    }

    public Components addResponse(String key, APIResponse response) {
        if (response != null) {
            if (this.responses == null) {
                this.responses = ModelUtils.createOrderedMap();
            }
            this.responses.put(key, response);
        }
        return this;
    }

    public void removeResponse(String key) {
        if (this.responses != null) {
            this.responses.remove(key);
        }
    }

    public Map<String, Parameter> getParameters() {
        return ModelUtils.readOnlyView(this.parameters);
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = ModelUtils.createOrderedMap(parameters);
    }

    public Components addParameter(String key, Parameter parameter) {
        if (parameter != null) {
            if (this.parameters == null) {
                this.parameters = ModelUtils.createOrderedMap();
            }
            this.parameters.put(key, parameter);
        }
        return this;
    }

    public void removeParameter(String key) {
        if (this.parameters != null) {
            this.parameters.remove(key);
        }
    }

    public Map<String, Example> getExamples() {
        return ModelUtils.readOnlyView(this.examples);
    }

    public void setExamples(Map<String, Example> examples) {
        this.examples = ModelUtils.createOrderedMap(examples);
    }

    public Components addExample(String key, Example example) {
        if (example != null) {
            if (this.examples == null) {
                this.examples = ModelUtils.createOrderedMap();
            }
            this.examples.put(key, example);
        }
        return this;
    }

    public void removeExample(String key) {
        if (this.examples != null) {
            this.examples.remove(key);
        }
    }

    public Map<String, RequestBody> getRequestBodies() {
        return ModelUtils.readOnlyView(this.requestBodies);
    }

    public void setRequestBodies(Map<String, RequestBody> requestBodies) {
        this.requestBodies = ModelUtils.createOrderedMap(requestBodies);
    }

    public Components addRequestBody(String key, RequestBody requestBody) {
        if (requestBody != null) {
            if (this.requestBodies == null) {
                this.requestBodies = ModelUtils.createOrderedMap();
            }
            this.requestBodies.put(key, requestBody);
        }
        return this;
    }

    public void removeRequestBody(String key) {
        if (this.requestBodies != null) {
            this.requestBodies.remove(key);
        }
    }

    public Map<String, Header> getHeaders() {
        return ModelUtils.readOnlyView(this.headers);
    }

    public void setHeaders(Map<String, Header> headers) {
        this.headers = ModelUtils.createOrderedMap(headers);
    }

    public Components addHeader(String key, Header header) {
        if (header != null) {
            if (this.headers == null) {
                this.headers = ModelUtils.createOrderedMap();
            }
            this.headers.put(key, header);
        }
        return this;
    }

    public void removeHeader(String key) {
        if (this.headers != null) {
            this.headers.remove(key);
        }
    }

    public Map<String, SecurityScheme> getSecuritySchemes() {
        return ModelUtils.readOnlyView(this.securitySchemes);
    }

    public void setSecuritySchemes(Map<String, SecurityScheme> securitySchemes) {
        this.securitySchemes = ModelUtils.createOrderedMap(securitySchemes);
    }

    public Components addSecurityScheme(String key, SecurityScheme securityScheme) {
        if (securityScheme != null) {
            if (this.securitySchemes == null) {
                this.securitySchemes = ModelUtils.createOrderedMap();
            }
            this.securitySchemes.put(key, securityScheme);
        }
        return this;
    }

    public void removeSecurityScheme(String key) {
        if (this.securitySchemes != null) {
            this.securitySchemes.remove(key);
        }
    }

    public Map<String, Link> getLinks() {
        return ModelUtils.readOnlyView(this.links);
    }

    public void setLinks(Map<String, Link> links) {
        this.links = ModelUtils.createOrderedMap(links);
    }

    public Components addLink(String key, Link link) {
        if (link != null) {
            if (this.links == null) {
                this.links = ModelUtils.createOrderedMap();
            }
            this.links.put(key, link);
        }
        return this;
    }

    public void removeLink(String key) {
        if (this.links != null) {
            this.links.remove(key);
        }
    }

    public Map<String, Callback> getCallbacks() {
        return ModelUtils.readOnlyView(this.callbacks);
    }

    public void setCallbacks(Map<String, Callback> callbacks) {
        this.callbacks = ModelUtils.createOrderedMap(callbacks);
    }

    public Components addCallback(String key, Callback callback) {
        if (callback != null) {
            if (this.callbacks == null) {
                this.callbacks = ModelUtils.createOrderedMap();
            }
            this.callbacks.put(key, callback);
        }
        return this;
    }

    public void removeCallback(String key) {
        if (this.callbacks != null) {
            this.callbacks.remove(key);
        }
    }

    public static void merge(Components from, Components to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        to.setExtensions(ModelUtils.mergeProperty(to.getExtensions(), from.getExtensions(), override));
        if (from.getSchemas() != null) {
            for (Map.Entry fromEntry : from.getSchemas().entrySet()) {
                String schemaName = (String)fromEntry.getKey();
                if (schemaName == null) continue;
                Schema fromSchema = (Schema)fromEntry.getValue();
                Schema toSchema = to.getSchemas().getOrDefault(schemaName, new SchemaImpl());
                SchemaImpl.merge(fromSchema, toSchema, override, context);
                to.addSchema(schemaName, toSchema);
            }
        }
        if (from.getCallbacks() != null) {
            for (String callbackName : from.getCallbacks().keySet()) {
                if (callbackName == null) continue;
                CallbackImpl newCallback = new CallbackImpl();
                CallbackImpl.merge((Callback)from.getCallbacks().get(callbackName), newCallback, override, context);
                to.addCallback(callbackName, (Callback)newCallback);
            }
        }
        if (from.getExamples() != null) {
            for (String exampleName : from.getExamples().keySet()) {
                if (exampleName == null) continue;
                ExampleImpl newExample = new ExampleImpl();
                ExampleImpl.merge((Example)from.getExamples().get(exampleName), newExample, override);
                to.addExample(exampleName, (Example)newExample);
            }
        }
        if (from.getHeaders() != null) {
            for (String headerName : from.getHeaders().keySet()) {
                if (headerName == null) continue;
                HeaderImpl newHeader = new HeaderImpl();
                HeaderImpl.merge((Header)from.getHeaders().get(headerName), newHeader, override, context);
                to.addHeader(headerName, (Header)newHeader);
            }
        }
        if (from.getLinks() != null) {
            for (String linkName : from.getLinks().keySet()) {
                if (linkName == null) continue;
                LinkImpl newLink = new LinkImpl();
                LinkImpl.merge((Link)from.getLinks().get(linkName), newLink, override);
                to.addLink(linkName, (Link)newLink);
            }
        }
        if (from.getParameters() != null) {
            for (String parameterName : from.getParameters().keySet()) {
                if (parameterName == null) continue;
                ParameterImpl newParameter = new ParameterImpl();
                ParameterImpl.merge((Parameter)from.getParameters().get(parameterName), newParameter, override, context);
                to.addParameter(parameterName, (Parameter)newParameter);
            }
        }
        if (from.getRequestBodies() != null) {
            for (String requestBodyName : from.getRequestBodies().keySet()) {
                if (requestBodyName == null) continue;
                RequestBodyImpl newRequestBody = new RequestBodyImpl();
                RequestBodyImpl.merge((RequestBody)from.getRequestBodies().get(requestBodyName), newRequestBody, override, context);
                to.addRequestBody(requestBodyName, (RequestBody)newRequestBody);
            }
        }
        if (from.getResponses() != null) {
            for (String responseName : from.getResponses().keySet()) {
                if (responseName == null) continue;
                APIResponseImpl newResponse = new APIResponseImpl();
                APIResponseImpl.merge((APIResponse)from.getResponses().get(responseName), newResponse, override, context);
                to.addResponse(responseName, (APIResponse)newResponse);
            }
        }
        if (from.getSecuritySchemes() != null) {
            for (String securitySchemeName : from.getSecuritySchemes().keySet()) {
                if (securitySchemeName == null) continue;
                SecuritySchemeImpl newSecurity = new SecuritySchemeImpl();
                SecuritySchemeImpl.merge((SecurityScheme)from.getSecuritySchemes().get(securitySchemeName), newSecurity, override);
                to.addSecurityScheme(securitySchemeName, (SecurityScheme)newSecurity);
            }
        }
    }
}

