/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ComponentsImpl;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.ExternalDocumentationImpl;
import fish.payara.microprofile.openapi.impl.model.PathsImpl;
import fish.payara.microprofile.openapi.impl.model.info.InfoImpl;
import fish.payara.microprofile.openapi.impl.model.security.SecurityRequirementImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerImpl;
import fish.payara.microprofile.openapi.impl.model.tags.TagImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class OpenAPIImpl
extends ExtensibleImpl<OpenAPI>
implements OpenAPI,
Cloneable {
    protected String openapi;
    protected Info info;
    protected ExternalDocumentation externalDocs;
    protected List<Server> servers = ModelUtils.createList();
    protected List<SecurityRequirement> security = ModelUtils.createList();
    protected List<Tag> tags = ModelUtils.createList();
    protected Paths paths = new PathsImpl();
    protected Map<String, Set<String>> endpoints = ModelUtils.createOrderedMap();
    protected Components components = new ComponentsImpl();
    private ApiContext context;

    public static OpenAPI createInstance(AnnotationModel annotation, ApiContext context) {
        AnnotationModel externalDocs;
        OpenAPIImpl from = new OpenAPIImpl();
        from.context = context;
        AnnotationModel info = (AnnotationModel)annotation.getValue("info", AnnotationModel.class);
        if (info != null) {
            from.setInfo(InfoImpl.createInstance(info));
        }
        if ((externalDocs = (AnnotationModel)annotation.getValue("externalDocs", AnnotationModel.class)) != null) {
            from.setExternalDocs(ExternalDocumentationImpl.createInstance(externalDocs));
        }
        ModelUtils.extractAnnotations(annotation, context, "security", SecurityRequirementImpl::createInstance, from::addSecurityRequirement);
        ModelUtils.extractAnnotations(annotation, context, "securitySets", SecurityRequirementImpl::createInstances, from::addSecurityRequirement);
        ModelUtils.extractAnnotations(annotation, context, "servers", ServerImpl::createInstance, from::addServer);
        ModelUtils.extractAnnotations(annotation, context, "tags", TagImpl::createInstance, from::addTag);
        AnnotationModel components = (AnnotationModel)annotation.getValue("components", AnnotationModel.class);
        if (components != null) {
            from.setComponents(ComponentsImpl.createInstance(components, context));
        }
        from.setExtensions(OpenAPIImpl.parseExtensions(annotation));
        return from;
    }

    public final ApiContext getContext() {
        return this.context;
    }

    public String getOpenapi() {
        return this.openapi;
    }

    public void setOpenapi(String openapi) {
        this.openapi = openapi;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public List<Server> getServers() {
        return ModelUtils.readOnlyView(this.servers);
    }

    public void setServers(List<Server> servers) {
        this.servers = ModelUtils.createList(servers);
    }

    public OpenAPI addServer(Server server) {
        if (server == null) {
            return this;
        }
        String serverUrl = server.getUrl();
        if (this.servers == null) {
            this.servers = ModelUtils.createList();
        }
        for (Server existingServer : this.getServers()) {
            if (serverUrl == null || !serverUrl.equals(existingServer.getUrl())) continue;
            ModelUtils.merge(server, existingServer, true);
            return this;
        }
        this.servers.add(server);
        return this;
    }

    public void removeServer(Server server) {
        if (this.servers != null) {
            this.servers.remove(server);
        }
    }

    public List<SecurityRequirement> getSecurity() {
        return ModelUtils.readOnlyView(this.security);
    }

    public void setSecurity(List<SecurityRequirement> security) {
        this.security = ModelUtils.createList(security);
    }

    public OpenAPI addSecurityRequirement(SecurityRequirement securityRequirement) {
        if (securityRequirement != null) {
            if (this.security == null) {
                this.security = ModelUtils.createList();
            }
            this.security.add(securityRequirement);
        }
        return this;
    }

    public void removeSecurityRequirement(SecurityRequirement securityRequirement) {
        if (this.security != null) {
            this.security.remove(securityRequirement);
        }
    }

    public List<Tag> getTags() {
        return ModelUtils.readOnlyView(this.tags);
    }

    public void setTags(List<Tag> tags) {
        this.tags = ModelUtils.createList(tags);
    }

    public OpenAPI addTag(Tag tag) {
        if (this.tags == null) {
            this.tags = ModelUtils.createList();
        }
        this.tags.add(tag);
        return this;
    }

    public void removeTag(Tag tag) {
        if (this.tags != null) {
            this.tags.remove(tag);
        }
    }

    public Paths getPaths() {
        return this.paths;
    }

    public void setPaths(Paths paths) {
        this.paths = paths;
    }

    public Components getComponents() {
        return this.components;
    }

    public void setComponents(Components components) {
        this.components = components;
    }

    public static OpenAPI merge(OpenAPI parent, List<OpenAPI> children, boolean override) {
        for (OpenAPI child : children) {
            OpenAPIImpl.merge(child, parent, override, null);
        }
        return parent;
    }

    public static void merge(OpenAPI from, OpenAPI to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        to.setOpenapi(ModelUtils.mergeProperty(to.getOpenapi(), from.getOpenapi(), override));
        if (from.getInfo() != null) {
            if (to.getInfo() == null) {
                to.setInfo((Info)new InfoImpl());
            }
            InfoImpl.merge(from.getInfo(), to.getInfo(), override);
        }
        if (from.getServers() != null) {
            for (Server server : from.getServers()) {
                if (server == null) continue;
                ServerImpl newServer = new ServerImpl();
                ServerImpl.merge(server, newServer, true);
                if (to.getServers().contains(newServer)) continue;
                to.addServer((Server)newServer);
            }
        }
        if (from.getExternalDocs() != null) {
            if (to.getExternalDocs() == null) {
                to.setExternalDocs((ExternalDocumentation)new ExternalDocumentationImpl());
            }
            ExternalDocumentationImpl.merge(from.getExternalDocs(), to.getExternalDocs(), override);
        }
        ExtensibleImpl.merge(from, to, override);
        if (from.getSecurity() != null) {
            for (SecurityRequirement requirement : from.getSecurity()) {
                if (requirement == null) continue;
                SecurityRequirementImpl newRequirement = new SecurityRequirementImpl();
                SecurityRequirementImpl.merge(requirement, newRequirement);
                if (to.getSecurity().contains(newRequirement)) continue;
                to.addSecurityRequirement((SecurityRequirement)newRequirement);
            }
        }
        if (from.getTags() != null) {
            for (Tag tag : from.getTags()) {
                if (tag == null) continue;
                if (to.getTags() == null) {
                    to.setTags(ModelUtils.createList());
                }
                TagImpl newTag = new TagImpl();
                TagImpl.merge(tag, newTag, override);
                to.addTag((Tag)newTag);
            }
        }
        ComponentsImpl.merge(from.getComponents(), to.getComponents(), override, context);
        PathsImpl.merge(from.getPaths(), to.getPaths(), override);
        Map<String, Set<String>> endpoints = ((OpenAPIImpl)from).getEndpoints();
        if (!endpoints.isEmpty()) {
            OpenAPIImpl toImpl = (OpenAPIImpl)to;
            for (String root : endpoints.keySet()) {
                Set<String> paths = endpoints.get(root);
                toImpl.setEndpoints(ModelUtils.buildEndpoints(toImpl.getEndpoints(), root, paths));
            }
        }
    }

    public OpenAPI clone() throws CloneNotSupportedException {
        OpenAPIImpl clonedObj = new OpenAPIImpl();
        clonedObj.setOpenapi(this.openapi);
        clonedObj.setInfo(this.info);
        clonedObj.setExternalDocs(this.externalDocs);
        clonedObj.setServers(new ArrayList<Server>(this.servers));
        clonedObj.setSecurity(new ArrayList<SecurityRequirement>(this.security));
        clonedObj.setTags(new ArrayList<Tag>(this.tags));
        clonedObj.setPaths(new PathsImpl(this.paths.getPathItems()));
        clonedObj.setComponents(this.components);
        clonedObj.setExtensions(this.extensions);
        clonedObj.setEndpoints(new TreeMap<String, Set<String>>(this.getEndpoints()));
        return clonedObj;
    }

    public Map<String, Set<String>> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Map<String, Set<String>> endpoints) {
        this.endpoints = endpoints;
    }
}

