/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class PathItemImpl
extends ExtensibleImpl<PathItem>
implements PathItem {
    protected String ref;
    protected String summary;
    protected String description;
    protected Operation get;
    protected Operation put;
    protected Operation post;
    protected Operation delete;
    protected Operation options;
    protected Operation head;
    protected Operation patch;
    protected Operation trace;
    protected List<Server> servers = ModelUtils.createList();
    protected List<Parameter> parameters = ModelUtils.createList();

    public static PathItem createInstance(AnnotationModel annotation, ApiContext context) {
        PathItemImpl from = new PathItemImpl();
        ModelUtils.extractAnnotations(annotation, context, "servers", ServerImpl::createInstance, arg_0 -> ((PathItem)from).addServer(arg_0));
        from.setExtensions(PathItemImpl.parseExtensions(annotation));
        return from;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Operation getGET() {
        return this.get;
    }

    public void setGET(Operation get) {
        this.get = get;
    }

    public Operation getPUT() {
        return this.put;
    }

    public void setPUT(Operation put) {
        this.put = put;
    }

    public Operation getPOST() {
        return this.post;
    }

    public void setPOST(Operation post) {
        this.post = post;
    }

    public Operation getDELETE() {
        return this.delete;
    }

    public void setDELETE(Operation delete) {
        this.delete = delete;
    }

    public Operation getOPTIONS() {
        return this.options;
    }

    public void setOPTIONS(Operation options) {
        this.options = options;
    }

    public Operation getHEAD() {
        return this.head;
    }

    public void setHEAD(Operation head) {
        this.head = head;
    }

    public Operation getPATCH() {
        return this.patch;
    }

    public void setPATCH(Operation patch) {
        this.patch = patch;
    }

    public Operation getTRACE() {
        return this.trace;
    }

    public void setTRACE(Operation trace) {
        this.trace = trace;
    }

    public Map<PathItem.HttpMethod, Operation> getOperations() {
        EnumMap<PathItem.HttpMethod, Operation> result = new EnumMap<PathItem.HttpMethod, Operation>(PathItem.HttpMethod.class);
        if (this.get != null) {
            result.put(PathItem.HttpMethod.GET, this.get);
        }
        if (this.put != null) {
            result.put(PathItem.HttpMethod.PUT, this.put);
        }
        if (this.post != null) {
            result.put(PathItem.HttpMethod.POST, this.post);
        }
        if (this.delete != null) {
            result.put(PathItem.HttpMethod.DELETE, this.delete);
        }
        if (this.patch != null) {
            result.put(PathItem.HttpMethod.PATCH, this.patch);
        }
        if (this.head != null) {
            result.put(PathItem.HttpMethod.HEAD, this.head);
        }
        if (this.options != null) {
            result.put(PathItem.HttpMethod.OPTIONS, this.options);
        }
        if (this.trace != null) {
            result.put(PathItem.HttpMethod.TRACE, this.trace);
        }
        return result;
    }

    public void setOperation(PathItem.HttpMethod httpMethod, Operation operation) {
        if (httpMethod == null) {
            return;
        }
        switch (httpMethod) {
            case GET: {
                this.get = operation;
                break;
            }
            case PUT: {
                this.put = operation;
                break;
            }
            case POST: {
                this.post = operation;
                break;
            }
            case DELETE: {
                this.delete = operation;
                break;
            }
            case OPTIONS: {
                this.options = operation;
                break;
            }
            case HEAD: {
                this.head = operation;
                break;
            }
            case PATCH: {
                this.patch = operation;
                break;
            }
            case TRACE: {
                this.trace = operation;
            }
        }
    }

    public List<Server> getServers() {
        return ModelUtils.readOnlyView(this.servers);
    }

    public void setServers(List<Server> servers) {
        this.servers = ModelUtils.createList(servers);
    }

    public PathItem addServer(Server server) {
        if (server != null) {
            if (this.servers == null) {
                this.servers = ModelUtils.createList();
            }
            this.servers.add(server);
        }
        return this;
    }

    public void removeServer(Server server) {
        if (this.servers != null) {
            this.servers.remove(server);
        }
    }

    public List<Parameter> getParameters() {
        return ModelUtils.readOnlyView(this.parameters);
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = ModelUtils.createList(parameters);
    }

    public PathItem addParameter(Parameter parameter) {
        if (parameter != null) {
            if (this.parameters == null) {
                this.parameters = ModelUtils.createList();
            }
            this.parameters.add(parameter);
        }
        return this;
    }

    public void removeParameter(Parameter parameter) {
        if (this.parameters != null) {
            this.parameters.remove(parameter);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathItemImpl other = (PathItemImpl)obj;
        if (!Objects.equals(this.ref, other.ref)) {
            return false;
        }
        if (!Objects.equals(this.summary, other.summary)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.get, other.get)) {
            return false;
        }
        if (!Objects.equals(this.put, other.put)) {
            return false;
        }
        if (!Objects.equals(this.post, other.post)) {
            return false;
        }
        if (!Objects.equals(this.delete, other.delete)) {
            return false;
        }
        if (!Objects.equals(this.options, other.options)) {
            return false;
        }
        if (!Objects.equals(this.head, other.head)) {
            return false;
        }
        if (!Objects.equals(this.patch, other.patch)) {
            return false;
        }
        if (!Objects.equals(this.trace, other.trace)) {
            return false;
        }
        if (!Objects.equals(this.servers, other.servers)) {
            return false;
        }
        return Objects.equals(this.parameters, other.parameters);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.ref);
        hash = 37 * hash + Objects.hashCode(this.summary);
        hash = 37 * hash + Objects.hashCode(this.description);
        hash = 37 * hash + Objects.hashCode(this.get);
        hash = 37 * hash + Objects.hashCode(this.put);
        hash = 37 * hash + Objects.hashCode(this.post);
        hash = 37 * hash + Objects.hashCode(this.delete);
        hash = 37 * hash + Objects.hashCode(this.options);
        hash = 37 * hash + Objects.hashCode(this.head);
        hash = 37 * hash + Objects.hashCode(this.patch);
        hash = 37 * hash + Objects.hashCode(this.trace);
        hash = 37 * hash + Objects.hashCode(this.servers);
        hash = 37 * hash + Objects.hashCode(this.parameters);
        return hash;
    }
}

