/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.responses;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.headers.HeaderImpl;
import fish.payara.microprofile.openapi.impl.model.links.LinkImpl;
import fish.payara.microprofile.openapi.impl.model.media.ContentImpl;
import fish.payara.microprofile.openapi.impl.model.media.MediaTypeImpl;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class APIResponseImpl
extends ExtensibleImpl<APIResponse>
implements APIResponse {
    private String description;
    private Map<String, Header> headers = ModelUtils.createMap();
    private Content content = new ContentImpl();
    private Map<String, Link> links = ModelUtils.createMap();
    private String ref;
    private String responseCode;

    public static APIResponseImpl createInstance(AnnotationModel annotation, ApiContext context) {
        APIResponseImpl from = new APIResponseImpl();
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setExtensions(APIResponseImpl.parseExtensions(annotation));
        HeaderImpl.createInstances(annotation, context).forEach(from::addHeader);
        List<ContentImpl> contents = ModelUtils.createList();
        String implementationClass = (String)annotation.getValue("value", String.class);
        if (implementationClass != null) {
            ContentImpl content = new ContentImpl().addMediaType("*/*", new MediaTypeImpl().schema(SchemaImpl.fromImplementation(implementationClass, context)));
            contents.add(content);
            from.setDescription((String)annotation.getValue("responseDescription", String.class));
        }
        ModelUtils.extractAnnotations(annotation, context, "content", ContentImpl::createInstance, contents::add);
        for (ContentImpl content : contents) {
            content.getMediaTypes().forEach((arg_0, arg_1) -> ((Content)from.content).addMediaType(arg_0, arg_1));
            if (content.getExtensions() == null) continue;
            content.getExtensions().forEach((extKey, extValue) -> content.getMediaTypes().forEach((mtKey, mtValue) -> from.content.getMediaType(mtKey).addExtension(extKey, extValue)));
        }
        ModelUtils.extractAnnotations(annotation, context, "links", "name", LinkImpl::createInstance, from::addLink);
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        from.setResponseCode((String)annotation.getValue("responseCode", String.class));
        return from;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Header> getHeaders() {
        return ModelUtils.readOnlyView(this.headers);
    }

    public void setHeaders(Map<String, Header> headers) {
        this.headers = ModelUtils.createMap(headers);
    }

    public APIResponse addHeader(String name, Header header) {
        if (header != null) {
            if (this.headers == null) {
                this.headers = ModelUtils.createMap();
            }
            this.headers.put(name, header);
        }
        return this;
    }

    public void removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
        }
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public Map<String, Link> getLinks() {
        return ModelUtils.readOnlyView(this.links);
    }

    public void setLinks(Map<String, Link> links) {
        this.links = ModelUtils.createMap(links);
    }

    public APIResponse addLink(String name, Link link) {
        if (link != null) {
            if (this.links == null) {
                this.links = ModelUtils.createMap();
            }
            this.links.put(name, link);
        }
        return this;
    }

    public void removeLink(String name) {
        if (this.links != null) {
            this.links.remove(name);
        }
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !((String)ref).contains(".") && !((String)ref).contains("/")) {
            ref = "#/components/responses/" + (String)ref;
        }
        this.ref = ref;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public static void merge(APIResponse from, APIResponse to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        ExtensibleImpl.merge(from, to, override);
        if (from.getContent() != null) {
            if (to.getContent() == null) {
                to.setContent((Content)new ContentImpl());
            }
            ContentImpl.merge((ContentImpl)from.getContent(), to.getContent(), override, context);
        }
        if (from.getHeaders() != null) {
            for (Map.Entry header : from.getHeaders().entrySet()) {
                HeaderImpl.merge((String)header.getKey(), (Header)header.getValue(), ((APIResponseImpl)to).headers, override, context);
            }
        }
        if (from.getLinks() != null) {
            for (Map.Entry link : from.getLinks().entrySet()) {
                LinkImpl.merge((String)link.getKey(), (Link)link.getValue(), ((APIResponseImpl)to).links, override);
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.responseCode);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        APIResponseImpl other = (APIResponseImpl)obj;
        return Objects.equals(this.responseCode, other.responseCode);
    }
}

