/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.responses;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.ExtensibleTreeMap;
import fish.payara.microprofile.openapi.impl.model.responses.APIResponseImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class APIResponsesImpl
extends ExtensibleTreeMap<APIResponse, APIResponses>
implements APIResponses {
    private static final long serialVersionUID = 2811935761440110541L;

    public APIResponsesImpl() {
    }

    public APIResponsesImpl(Map<String, APIResponse> responses) {
        super(responses);
    }

    public static APIResponsesImpl createInstance(AnnotationModel annotation, ApiContext context) {
        APIResponsesImpl from = new APIResponsesImpl();
        from.setExtensions(ExtensibleImpl.parseExtensions(annotation));
        ModelUtils.extractAnnotations(annotation, context, "value", "responseCode", APIResponseImpl::createInstance, from::addAPIResponse);
        return from;
    }

    public APIResponses addAPIResponse(String name, APIResponse apiResponse) {
        if (apiResponse != null) {
            this.put(name, apiResponse);
        }
        return this;
    }

    public void removeAPIResponse(String name) {
        this.remove(name);
    }

    public Map<String, APIResponse> getAPIResponses() {
        return ModelUtils.readOnlyView(this);
    }

    public void setAPIResponses(Map<String, APIResponse> items) {
        this.clear();
        this.putAll(items);
    }

    public APIResponse getDefaultValue() {
        return (APIResponse)this.get("default");
    }

    public void setDefaultValue(APIResponse defaultValue) {
        this.put("default", defaultValue);
    }

    public static void merge(APIResponse from, APIResponses to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        String responseName = null;
        if (from instanceof APIResponseImpl) {
            responseName = ((APIResponseImpl)from).getResponseCode();
        }
        if (responseName == null || responseName.isEmpty()) {
            responseName = "default";
        }
        APIResponse response = to.getAPIResponses().getOrDefault(responseName, new APIResponseImpl());
        to.addAPIResponse(responseName, response);
        ExtensibleImpl.merge(from, response, override);
        APIResponseImpl.merge(from, response, override, context);
    }

    public static void merge(APIResponses from, APIResponses to, boolean override, ApiContext context) {
        ExtensibleImpl.merge(from, to, override);
    }
}

