/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.security;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.security.OAuthFlowsImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.EnumModel;

public class SecuritySchemeImpl
extends ExtensibleImpl<SecurityScheme>
implements SecurityScheme {
    private SecurityScheme.Type type;
    private String description;
    private String name;
    private String ref;
    private SecurityScheme.In in;
    private String scheme;
    private String bearerFormat;
    private OAuthFlows flows;
    private String openIdConnectUrl;
    private String apiKeyName;

    public static SecurityScheme createInstance(AnnotationModel annotation, ApiContext context) {
        EnumModel in;
        SecuritySchemeImpl from = new SecuritySchemeImpl();
        EnumModel type = (EnumModel)annotation.getValue("type", EnumModel.class);
        if (type != null) {
            from.setType(SecurityScheme.Type.valueOf((String)type.getValue()));
        }
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setExtensions(SecuritySchemeImpl.parseExtensions(annotation));
        from.setName((String)annotation.getValue("apiKeyName", String.class));
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        if ((in = (EnumModel)annotation.getValue("in", EnumModel.class)) != null) {
            from.setIn(SecurityScheme.In.valueOf((String)in.getValue()));
        }
        from.setScheme((String)annotation.getValue("scheme", String.class));
        from.setBearerFormat((String)annotation.getValue("bearerFormat", String.class));
        AnnotationModel flowsAnnotation = (AnnotationModel)annotation.getValue("flows", AnnotationModel.class);
        if (flowsAnnotation != null) {
            from.setFlows(OAuthFlowsImpl.createInstance(flowsAnnotation));
        }
        from.setOpenIdConnectUrl((String)annotation.getValue("openIdConnectUrl", String.class));
        return from;
    }

    public SecurityScheme.Type getType() {
        return this.type;
    }

    public void setType(SecurityScheme.Type type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityScheme.In getIn() {
        return this.in;
    }

    public void setIn(SecurityScheme.In in) {
        this.in = in;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getBearerFormat() {
        return this.bearerFormat;
    }

    public void setBearerFormat(String bearerFormat) {
        this.bearerFormat = bearerFormat;
    }

    public OAuthFlows getFlows() {
        return this.flows;
    }

    public void setFlows(OAuthFlows flows) {
        this.flows = flows;
    }

    public String getOpenIdConnectUrl() {
        return this.openIdConnectUrl;
    }

    public void setOpenIdConnectUrl(String openIdConnectUrl) {
        this.openIdConnectUrl = openIdConnectUrl;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !((String)ref).contains(".") && !((String)ref).contains("/")) {
            ref = "#/components/securitySchemes/" + (String)ref;
        }
        this.ref = ref;
    }

    public static void merge(SecurityScheme from, SecurityScheme to, boolean override) {
        if (from == null) {
            return;
        }
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        to.setName(ModelUtils.mergeProperty(to.getName(), from.getName(), override));
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        to.setExtensions(ModelUtils.mergeProperty(to.getExtensions(), from.getExtensions(), override));
        to.setScheme(ModelUtils.mergeProperty(to.getScheme(), from.getScheme(), override));
        to.setBearerFormat(ModelUtils.mergeProperty(to.getBearerFormat(), from.getBearerFormat(), override));
        to.setOpenIdConnectUrl(ModelUtils.mergeProperty(to.getOpenIdConnectUrl(), from.getOpenIdConnectUrl(), override));
        if (from.getIn() != null) {
            to.setIn(ModelUtils.mergeProperty(to.getIn(), from.getIn(), override));
        }
        if (from.getType() != null) {
            to.setType(ModelUtils.mergeProperty(to.getType(), from.getType(), override));
        }
        if (from.getFlows() != null) {
            OAuthFlowsImpl flows = new OAuthFlowsImpl();
            OAuthFlowsImpl.merge(from.getFlows(), flows, override);
            to.setFlows((OAuthFlows)ModelUtils.mergeProperty(to.getFlows(), flows, override));
        }
    }
}

