/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.servers;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerVariableImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class ServerImpl
extends ExtensibleImpl<Server>
implements Server {
    private String url;
    private String description;
    private Map<String, ServerVariable> variables = ModelUtils.createMap();

    public static Server createInstance(AnnotationModel annotation, ApiContext context) {
        ServerImpl from = new ServerImpl();
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setExtensions(ServerImpl.parseExtensions(annotation));
        from.setUrl((String)annotation.getValue("url", String.class));
        ModelUtils.extractAnnotations(annotation, context, "variables", "name", ServerVariableImpl::createInstance, (arg_0, arg_1) -> ((Server)from).addVariable(arg_0, arg_1));
        return from;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, ServerVariable> getVariables() {
        return ModelUtils.readOnlyView(this.variables);
    }

    public Server addVariable(String variableName, ServerVariable variable) {
        if (variableName != null && variable != null) {
            if (this.variables == null) {
                this.variables = ModelUtils.createMap();
            }
            this.variables.put(variableName, variable);
        }
        return this;
    }

    public void removeVariable(String variableName) {
        if (this.variables != null) {
            this.variables.remove(variableName);
        }
    }

    public void setVariables(Map<String, ServerVariable> variables) {
        this.variables = ModelUtils.createMap(variables);
    }

    public static void merge(Server from, Server to, boolean override) {
        if (from == null) {
            return;
        }
        to.setUrl(ModelUtils.mergeProperty(to.getUrl(), from.getUrl(), override));
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        to.setExtensions(ModelUtils.mergeProperty(to.getExtensions(), from.getExtensions(), override));
        if (from.getVariables() != null) {
            for (String serverVariableName : from.getVariables().keySet()) {
                ServerImpl.merge(serverVariableName, (ServerVariable)from.getVariables().get(serverVariableName), ((ServerImpl)to).variables, override);
            }
        }
    }

    public static void merge(String serverVariableName, ServerVariable from, Map<String, ServerVariable> to, boolean override) {
        if (from == null) {
            return;
        }
        ServerVariableImpl variable = new ServerVariableImpl();
        variable.setDefaultValue(ModelUtils.mergeProperty(variable.getDefaultValue(), from.getDefaultValue(), override));
        variable.setDescription(ModelUtils.mergeProperty(variable.getDescription(), from.getDescription(), override));
        variable.setExtensions(ModelUtils.mergeProperty(variable.getExtensions(), from.getExtensions(), override));
        if (from.getEnumeration() != null && !from.getEnumeration().isEmpty()) {
            if (variable.getEnumeration() == null) {
                variable.setEnumeration(ModelUtils.createList());
            }
            for (String value : from.getEnumeration()) {
                variable.addEnumeration(value);
            }
        }
        if (to.containsKey(serverVariableName) && override || !to.containsKey(serverVariableName)) {
            to.put(serverVariableName, variable);
        }
    }
}

