/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.rest.app.provider;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import fish.payara.microprofile.openapi.impl.model.OASFactoryResolverImpl;
import fish.payara.microprofile.openapi.impl.rest.app.provider.mixin.ExtensionsMixin;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.Constructible;

public final class ObjectMapperFactory {
    private ObjectMapperFactory() {
    }

    public static ObjectMapper createJson() {
        return ObjectMapperFactory.create(new JsonFactory());
    }

    public static ObjectMapper createYaml() {
        YAMLFactory factory = new YAMLFactory();
        factory.disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        factory.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        factory.enable(YAMLGenerator.Feature.SPLIT_LINES);
        factory.enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS);
        return ObjectMapperFactory.create((JsonFactory)factory);
    }

    public static <T extends Constructible> ObjectMapper create(JsonFactory factory) {
        ObjectMapper mapper = new ObjectMapper(factory);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        SimpleModule module = new SimpleModule();
        for (Map.Entry<Class<? extends Constructible>, Class<? extends Constructible>> entry : OASFactoryResolverImpl.MODEL_MAP.entrySet()) {
            module.addAbstractTypeMapping(entry.getKey(), entry.getValue());
        }
        mapper.setMixIns(OASFactoryResolverImpl.MODEL_MAP.keySet().stream().collect(Collectors.toMap(Function.identity(), c -> ExtensionsMixin.class)));
        mapper.registerModule((Module)module);
        return mapper;
    }
}

