/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.visitor;

import fish.payara.microprofile.openapi.api.visitor.ApiVisitor;
import fish.payara.microprofile.openapi.api.visitor.ApiWalker;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.visitor.AnnotationInfo;
import fish.payara.microprofile.openapi.impl.visitor.OpenApiContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.microprofile.openapi.annotations.ExternalDocumentation;
import org.eclipse.microprofile.openapi.annotations.OpenAPIDefinition;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.callbacks.Callback;
import org.eclipse.microprofile.openapi.annotations.callbacks.Callbacks;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.extensions.Extensions;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameters;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBodySchema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponseSchema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirements;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirementsSet;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirementsSets;
import org.eclipse.microprofile.openapi.annotations.security.SecurityScheme;
import org.eclipse.microprofile.openapi.annotations.security.SecuritySchemes;
import org.eclipse.microprofile.openapi.annotations.servers.Server;
import org.eclipse.microprofile.openapi.annotations.servers.Servers;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.eclipse.microprofile.openapi.annotations.tags.Tags;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.Type;

public class OpenApiWalker<E extends AnnotatedElement>
implements ApiWalker {
    private final Set<Type> allowedTypes = new TreeSet<Type>(Comparator.comparing(AnnotatedElement::getName, String::compareTo));
    private final OpenApiContext context;
    private Map<Class<? extends Annotation>, ApiVisitor.VisitorFunction<AnnotationModel, E>> annotationVisitor;
    private Map<Class<? extends Annotation>, List<Class<? extends Annotation>>> annotationAlternatives;

    public OpenApiWalker(OpenAPI api, Map<String, Type> allTypes, Set<Type> allowedTypes, ClassLoader appClassLoader) {
        this.allowedTypes.addAll(allowedTypes);
        this.context = new OpenApiContext(allTypes, this.allowedTypes, appClassLoader, api);
    }

    @Override
    public void accept(ApiVisitor visitor) {
        for (Type type : this.allowedTypes) {
            if (!(type instanceof ClassModel)) continue;
            this.processAnnotation((ClassModel)type, visitor);
        }
        this.syncSchemas();
    }

    public final void processAnnotation(ClassModel annotatedClass, ApiVisitor visitor) {
        AnnotationInfo annotations = this.context.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)annotatedClass);
        this.processAnnotation(annotatedClass, annotations, visitor, new OpenApiContext(this.context, (AnnotatedElement)annotatedClass));
        for (MethodModel method : annotatedClass.getMethods()) {
            this.processAnnotation(method, annotations, visitor, new OpenApiContext(this.context, (AnnotatedElement)method));
        }
        for (FieldModel field : annotatedClass.getFields()) {
            this.processAnnotation(field, annotations, visitor, new OpenApiContext(this.context, (AnnotatedElement)field));
        }
        for (MethodModel method : annotatedClass.getMethods()) {
            for (org.glassfish.hk2.classmodel.reflect.Parameter parameter : method.getParameters()) {
                this.processAnnotation(parameter, annotations, visitor, new OpenApiContext(this.context, (AnnotatedElement)method));
            }
        }
    }

    private void processAnnotation(E element, AnnotationInfo annotations, ApiVisitor visitor, OpenApiContext context) {
        for (Class<Annotation> annotationClass : this.getAnnotationVisitor(visitor).keySet()) {
            ApiVisitor.VisitorFunction<AnnotationModel, E> annotationFunction = this.getAnnotationVisitor(visitor).get(annotationClass);
            List<Class<Annotation>> alternatives = this.getAnnotationAlternatives().get(annotationClass);
            if (annotations.isAnnotationPresent((Class<? extends Annotation>)annotationClass, (AnnotatedElement)element)) {
                if (element instanceof FieldModel && (annotationClass == HeaderParam.class || annotationClass == CookieParam.class || annotationClass == PathParam.class || annotationClass == QueryParam.class)) {
                    FieldModel field = (FieldModel)element;
                    for (MethodModel methodModel : field.getDeclaringType().getMethods()) {
                        OpenApiContext methodContext = new OpenApiContext(context, (AnnotatedElement)methodModel);
                        if (methodContext.getWorkingOperation() == null) continue;
                        annotationFunction.apply(annotations.getAnnotation((Class<? extends Annotation>)annotationClass, (AnnotatedElement)element), element, methodContext);
                    }
                    continue;
                }
                if (element instanceof MethodModel && (annotationClass == APIResponse.class || annotationClass == APIResponses.class) && annotations.isAnnotationPresent(annotationClass)) {
                    annotationFunction.apply(annotations.getAnnotation(annotationClass), element, context);
                }
                annotationFunction.apply(annotations.getAnnotation((Class<? extends Annotation>)annotationClass, (AnnotatedElement)element), element, context);
                continue;
            }
            if (!(element instanceof MethodModel) || !annotations.isAnnotationPresent(annotationClass)) continue;
            boolean process = true;
            if (alternatives != null) {
                for (Class clazz : alternatives) {
                    if (!annotations.isAnnotationPresent((Class<? extends Annotation>)clazz, (AnnotatedElement)element)) continue;
                    process = false;
                    break;
                }
            }
            if (!process || context.getPath() == null) continue;
            annotationFunction.apply(annotations.getAnnotation(annotationClass), element, context);
        }
        if (element instanceof MethodModel && annotations.isAnnotationPresent((Class<? extends Annotation>)Extension.class, (AnnotatedElement)element)) {
            OpenApiContext methodContext = new OpenApiContext(context, (AnnotatedElement)element);
            this.propagateExtension(methodContext);
        }
    }

    private void propagateExtension(OpenApiContext methodContext) {
        for (org.eclipse.microprofile.openapi.models.responses.APIResponse apiResponse : methodContext.getWorkingOperation().getResponses().getAPIResponses().values()) {
            if (apiResponse.getExtensions() != null) continue;
            ExtensibleImpl.merge(methodContext.getWorkingOperation(), apiResponse, true);
        }
    }

    private Map<Class<? extends Annotation>, ApiVisitor.VisitorFunction<AnnotationModel, E>> getAnnotationVisitor(ApiVisitor visitor) {
        if (this.annotationVisitor == null) {
            this.annotationVisitor = new LinkedHashMap<Class<? extends Annotation>, ApiVisitor.VisitorFunction<AnnotationModel, E>>();
            this.annotationVisitor.put(OpenAPIDefinition.class, visitor::visitOpenAPI);
            this.annotationVisitor.put(GET.class, (annot, element, con) -> visitor.visitGET((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(POST.class, (annot, element, con) -> visitor.visitPOST((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(PUT.class, (annot, element, con) -> visitor.visitPUT((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(DELETE.class, (annot, element, con) -> visitor.visitDELETE((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(HEAD.class, (annot, element, con) -> visitor.visitHEAD((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(OPTIONS.class, (annot, element, con) -> visitor.visitOPTIONS((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(PATCH.class, (annot, element, con) -> visitor.visitPATCH((AnnotationModel)annot, (MethodModel)element, con));
            this.annotationVisitor.put(Path.class, (annot, element, con) -> {
                AnnotationModel annotationModel;
                if (element instanceof MethodModel && element.getAnnotations().size() == 1 && "Path".equals((annotationModel = (AnnotationModel)element.getAnnotations().iterator().next()).getType().getSimpleName())) {
                    visitor.visitGET((AnnotationModel)annot, (MethodModel)element, con);
                }
            });
            this.annotationVisitor.put(QueryParam.class, visitor::visitQueryParam);
            this.annotationVisitor.put(PathParam.class, visitor::visitPathParam);
            this.annotationVisitor.put(HeaderParam.class, visitor::visitHeaderParam);
            this.annotationVisitor.put(CookieParam.class, visitor::visitCookieParam);
            this.annotationVisitor.put(FormParam.class, visitor::visitFormParam);
            this.annotationVisitor.put(Schema.class, visitor::visitSchema);
            this.annotationVisitor.put(XmlRootElement.class, visitor::visitSchema);
            this.annotationVisitor.put(Server.class, visitor::visitServer);
            this.annotationVisitor.put(Servers.class, visitor::visitServers);
            this.annotationVisitor.put(Extensions.class, visitor::visitExtensions);
            this.annotationVisitor.put(Extension.class, visitor::visitExtension);
            this.annotationVisitor.put(Operation.class, visitor::visitOperation);
            this.annotationVisitor.put(Callback.class, visitor::visitCallback);
            this.annotationVisitor.put(Callbacks.class, visitor::visitCallbacks);
            this.annotationVisitor.put(APIResponse.class, visitor::visitAPIResponse);
            this.annotationVisitor.put(APIResponses.class, visitor::visitAPIResponses);
            this.annotationVisitor.put(APIResponseSchema.class, visitor::visitAPIResponseSchema);
            this.annotationVisitor.put(Parameters.class, visitor::visitParameters);
            this.annotationVisitor.put(Parameter.class, visitor::visitParameter);
            this.annotationVisitor.put(ExternalDocumentation.class, visitor::visitExternalDocumentation);
            this.annotationVisitor.put(Tag.class, visitor::visitTag);
            this.annotationVisitor.put(Tags.class, visitor::visitTags);
            this.annotationVisitor.put(SecurityScheme.class, visitor::visitSecurityScheme);
            this.annotationVisitor.put(SecuritySchemes.class, visitor::visitSecuritySchemes);
            this.annotationVisitor.put(SecurityRequirement.class, visitor::visitSecurityRequirement);
            this.annotationVisitor.put(SecurityRequirements.class, visitor::visitSecurityRequirements);
            this.annotationVisitor.put(SecurityRequirementsSet.class, visitor::visitSecurityRequirementSet);
            this.annotationVisitor.put(SecurityRequirementsSets.class, visitor::visitSecurityRequirementSets);
            this.annotationVisitor.put(Produces.class, visitor::visitProduces);
            this.annotationVisitor.put(Consumes.class, visitor::visitConsumes);
            this.annotationVisitor.put(RequestBody.class, visitor::visitRequestBody);
            this.annotationVisitor.put(RequestBodySchema.class, visitor::visitRequestBodySchema);
        }
        return this.annotationVisitor;
    }

    private Map<Class<? extends Annotation>, List<Class<? extends Annotation>>> getAnnotationAlternatives() {
        if (this.annotationAlternatives == null) {
            this.annotationAlternatives = new HashMap<Class<? extends Annotation>, List<Class<? extends Annotation>>>();
            this.annotationAlternatives.put(Server.class, Collections.singletonList(Servers.class));
            this.annotationAlternatives.put(Servers.class, Collections.singletonList(Server.class));
            this.annotationAlternatives.put(Extensions.class, Collections.singletonList(Extension.class));
            this.annotationAlternatives.put(Extension.class, Collections.singletonList(Extensions.class));
            this.annotationAlternatives.put(Callback.class, Collections.singletonList(Callbacks.class));
            this.annotationAlternatives.put(Callbacks.class, Collections.singletonList(Callback.class));
            this.annotationAlternatives.put(APIResponse.class, Collections.singletonList(APIResponses.class));
            this.annotationAlternatives.put(APIResponses.class, Collections.singletonList(APIResponse.class));
            this.annotationAlternatives.put(Parameters.class, Collections.singletonList(Parameter.class));
            this.annotationAlternatives.put(Parameter.class, Collections.singletonList(Parameters.class));
            this.annotationAlternatives.put(Tag.class, Collections.singletonList(Tags.class));
            this.annotationAlternatives.put(Tags.class, Collections.singletonList(Tag.class));
            this.annotationAlternatives.put(SecurityScheme.class, Collections.singletonList(SecuritySchemes.class));
            this.annotationAlternatives.put(SecuritySchemes.class, Collections.singletonList(SecurityScheme.class));
            this.annotationAlternatives.put(SecurityRequirement.class, (List<Class<? extends Annotation>>)new ArrayList<Class<? extends Annotation>>(){
                {
                    this.add(SecurityRequirements.class);
                    this.add(SecurityRequirementsSet.class);
                    this.add(SecurityRequirementsSets.class);
                }
            });
            this.annotationAlternatives.put(SecurityRequirements.class, (List<Class<? extends Annotation>>)new ArrayList<Class<? extends Annotation>>(){
                {
                    this.add(SecurityRequirement.class);
                    this.add(SecurityRequirementsSet.class);
                    this.add(SecurityRequirementsSets.class);
                }
            });
            this.annotationAlternatives.put(SecurityRequirementsSet.class, (List<Class<? extends Annotation>>)new ArrayList<Class<? extends Annotation>>(){
                {
                    this.add(SecurityRequirement.class);
                    this.add(SecurityRequirements.class);
                    this.add(SecurityRequirementsSets.class);
                }
            });
            this.annotationAlternatives.put(SecurityRequirementsSets.class, (List<Class<? extends Annotation>>)new ArrayList<Class<? extends Annotation>>(){
                {
                    this.add(SecurityRequirement.class);
                    this.add(SecurityRequirements.class);
                    this.add(SecurityRequirementsSet.class);
                }
            });
        }
        return this.annotationAlternatives;
    }

    private void syncSchemas() {
        OpenAPI api = this.context.getApi();
        for (Map.Entry schemaEntry : this.context.getApi().getComponents().getSchemas().entrySet()) {
            if (schemaEntry.getValue() == null || ((org.eclipse.microprofile.openapi.models.media.Schema)schemaEntry.getValue()).getProperties() == null) continue;
            for (Map.Entry propSchemaEntry : ((org.eclipse.microprofile.openapi.models.media.Schema)schemaEntry.getValue()).getProperties().entrySet()) {
                SchemaImpl schemaImpl;
                if (!(propSchemaEntry.getValue() instanceof SchemaImpl) || (schemaImpl = (SchemaImpl)propSchemaEntry.getValue()).getImplementation() == null) continue;
                String[] implQualified = schemaImpl.getImplementation().split("\\.");
                org.eclipse.microprofile.openapi.models.media.Schema from = (org.eclipse.microprofile.openapi.models.media.Schema)this.context.getApi().getComponents().getSchemas().get(implQualified[implQualified.length - 1]);
                SchemaImpl.merge(from, schemaImpl, false, this.context);
            }
        }
        api.getPaths().getPathItems().forEach((s, t) -> t.getOperations().forEach((u, v) -> v.getResponses().getAPIResponses().forEach((w, x) -> {
            if (x.getContent() != null) {
                x.getContent().getMediaTypes().forEach((y, z) -> {
                    SchemaImpl toschema;
                    if (z.getSchema() instanceof SchemaImpl && (toschema = (SchemaImpl)z.getSchema()).getImplementation() != null) {
                        org.eclipse.microprofile.openapi.models.media.Schema from;
                        String[] implQualified = toschema.getImplementation().split("\\.");
                        String schemaClassName = implQualified[implQualified.length - 1];
                        if (schemaClassName.contains("$")) {
                            schemaClassName = schemaClassName.substring(schemaClassName.indexOf("$") + 1);
                        }
                        if ((from = (org.eclipse.microprofile.openapi.models.media.Schema)this.context.getApi().getComponents().getSchemas().get(schemaClassName)) != null) {
                            SchemaImpl.merge(from, toschema, false, this.context);
                        } else {
                            for (org.eclipse.microprofile.openapi.models.media.Schema fromSchema : this.context.getApi().getComponents().getSchemas().values()) {
                                SchemaImpl fromSchemaImpl;
                                if (!(fromSchema instanceof SchemaImpl) || (fromSchemaImpl = (SchemaImpl)fromSchema).getImplementation() == null || !fromSchemaImpl.getImplementation().equals(toschema.getImplementation())) continue;
                                SchemaImpl.merge(fromSchemaImpl, toschema, false, this.context);
                                break;
                            }
                        }
                    }
                });
            }
        })));
    }
}

