/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.persistence.eclipselink.cache.coordination;

import fish.payara.nucleus.eventbus.MessageReceiver;
import fish.payara.persistence.eclipselink.cache.coordination.HazelcastPayload;
import fish.payara.persistence.eclipselink.cache.coordination.HazelcastTopicStorage;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;

final class HazelcastTopic {
    private final String name;
    private final String messageListenerId;
    private final Set<UUID> publishedMessageIds = new ConcurrentSkipListSet<UUID>();

    HazelcastTopic(String name, MessageReceiver<HazelcastPayload> receiver) {
        this.name = name;
        this.messageListenerId = this.getStorage().registerMessageReceiver(name, receiver);
    }

    void publish(HazelcastPayload payload) {
        this.publishedMessageIds.add(payload.getId());
        this.getStorage().publish(this.name, payload);
    }

    boolean hasPublished(HazelcastPayload payload) {
        return this.publishedMessageIds.remove(payload.getId());
    }

    void destroy() {
        this.publishedMessageIds.clear();
        this.getStorage().removeMessageReceiver(this.messageListenerId);
    }

    private HazelcastTopicStorage getStorage() {
        return HazelcastTopicStorage.getInstance();
    }
}

