/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.grizzly.config.admin.cli;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@Service(name="restart-http-listeners")
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=NetworkListeners.class, opType=RestEndpoint.OpType.POST, description="Restarts all HTTP listeners")})
public class RestartHttpListenersCommand
implements AdminCommand {
    @Inject
    private Domain domain;
    @Inject
    private ServiceLocator locator;
    @Inject
    private Target targetUtil;
    @Inject
    private GrizzlyService service;
    @Param(name="target", optional=true, primary=true)
    private String target;
    @Param(name="all", optional=true)
    private Boolean all;

    public void execute(AdminCommandContext context) {
        boolean isAll;
        ActionReport report = context.getActionReport();
        boolean bl = isAll = this.all != null && this.all != false;
        if (isAll && this.target == null) {
            ActionReport.ExitCode exitCode = ClusterOperationUtil.replicateCommand((String)"restart-http-listeners", (FailurePolicy)FailurePolicy.Ignore, (FailurePolicy)FailurePolicy.Ignore, (FailurePolicy)FailurePolicy.Error, (Collection)this.domain.getAllTargets(), (AdminCommandContext)context, (ParameterMap)new ParameterMap(), (ServiceLocator)this.locator);
            report.setActionExitCode(exitCode);
        }
        if (report.hasFailures()) {
            return;
        }
        if (this.target != null && isAll) {
            report.setMessage("--all used together with --target and is ignored.");
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        }
        if (this.target == null) {
            this.target = "server";
        }
        Config config = this.targetUtil.getConfig(this.target);
        for (NetworkListener listener : config.getNetworkConfig().getNetworkListeners().getNetworkListener()) {
            try {
                if (!"admin-listener".equals(listener.getName())) {
                    this.service.restartNetworkListener(listener, 10L, TimeUnit.SECONDS);
                }
            }
            catch (Exception ex) {
                report.setMessage(MessageFormat.format("Failed to restart listener {0}, {1}", listener.getName(), ex.getMessage() == null ? "No reason given" : ex.getMessage()));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)ex);
                return;
            }
            if (report.hasFailures() || report.hasWarnings()) continue;
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }
}

