/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-protocol")
@PerLookup
@I18n(value="get.protocol")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=HttpService.class, opType=RestEndpoint.OpType.GET, path="get-protocol", description="get-protocol")})
public class GetProtocol
implements AdminCommand {
    private static final Logger logger = LogFacade.getLogger();
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(primary=true)
    private String protocolName;
    @Param(optional=true, shortName="v", defaultValue="false")
    private Boolean verbose;
    @Inject
    Target targetUtil;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.targetUtil.getConfig(this.target) == null) {
            report.failure(logger, MessageFormat.format(logger.getResourceBundle().getString("AS-WEB-ADMIN-00047"), this.target));
            return;
        }
        Config config = this.targetUtil.getConfig(this.target);
        List protocols = config.getNetworkConfig().getProtocols().getProtocol();
        Optional<Protocol> optionalProtocol = protocols.stream().filter(protocol -> protocol.getName().equals(this.protocolName)).findFirst();
        if (!optionalProtocol.isPresent()) {
            report.failure(logger, MessageFormat.format(logger.getResourceBundle().getString("AS-WEB-ADMIN-00049"), this.protocolName, this.target));
            return;
        }
        Protocol protocol2 = optionalProtocol.get();
        report.appendMessage(String.format("Name: %s\n", protocol2.getName()));
        report.appendMessage("\nHTTP:\n");
        report.appendMessage(String.format("Server Name: %s\n", protocol2.getHttp().getServerName()));
        report.appendMessage(String.format("Max Connections: %s seconds\n", protocol2.getHttp().getMaxConnections()));
        report.appendMessage(String.format("Default Virtual Server: %s\n", protocol2.getHttp().getDefaultVirtualServer()));
        report.appendMessage(String.format("Server Header: %s\n", protocol2.getHttp().getServerHeader()));
        report.appendMessage(String.format("X-Powered-By: %s\n", protocol2.getHttp().getXpoweredBy()));
        if (this.verbose.booleanValue()) {
            report.appendMessage(String.format("Request Timeout: %s seconds\n", protocol2.getHttp().getRequestTimeoutSeconds()));
            report.appendMessage(String.format("Timeout: %s seconds\n", protocol2.getHttp().getTimeoutSeconds()));
            report.appendMessage(String.format("DNS Lookup Enabled: %s\n", protocol2.getHttp().getDnsLookupEnabled()));
            report.appendMessage(String.format("X Frame Options: %s\n", protocol2.getHttp().getXframeOptions()));
        }
        report.appendMessage("\nHTTP/2:\n");
        report.appendMessage(String.format("Enabled: %s\n", protocol2.getHttp().getHttp2Enabled()));
        if (Boolean.parseBoolean(protocol2.getHttp().getHttp2Enabled())) {
            report.appendMessage(String.format("Push Enabled: %s\n", protocol2.getHttp().getHttp2PushEnabled()));
            report.appendMessage(String.format("Cipher Check: %s\n", !Boolean.parseBoolean(protocol2.getHttp().getHttp2DisableCipherCheck())));
            if (this.verbose.booleanValue()) {
                report.appendMessage(String.format("Max Concurrent Streams: %s\n", protocol2.getHttp().getHttp2MaxConcurrentStreams()));
                report.appendMessage(String.format("Initial Window Size: %s bytes\n", protocol2.getHttp().getHttp2InitialWindowSizeInBytes()));
                report.appendMessage(String.format("Max Frame Payload Size: %s bytes\n", protocol2.getHttp().getHttp2MaxFramePayloadSizeInBytes()));
                report.appendMessage(String.format("Max Header List Size: %s bytes\n", protocol2.getHttp().getHttp2MaxHeaderListSizeInBytes()));
                report.appendMessage(String.format("Streams High Water Mark: %s\n", protocol2.getHttp().getHttp2StreamsHighWaterMark()));
                report.appendMessage(String.format("Clean Percentage: %s\n", protocol2.getHttp().getHttp2CleanPercentage()));
                report.appendMessage(String.format("Clean Frequency Check: %s\n", protocol2.getHttp().getHttp2CleanFrequencyCheck()));
            }
        }
        Properties properties = new Properties();
        properties.put("name", protocol2.getName());
        properties.put("serverName", protocol2.getHttp().getServerName() == null ? "null" : protocol2.getHttp().getServerName());
        properties.put("maxConnections", protocol2.getHttp().getMaxConnections());
        properties.put("defaultVirtualServer", protocol2.getHttp().getDefaultVirtualServer());
        properties.put("serverHeader", protocol2.getHttp().getServerHeader());
        properties.put("xPoweredBy", protocol2.getHttp().getXpoweredBy());
        properties.put("requestTimeoutSeconds", protocol2.getHttp().getRequestTimeoutSeconds());
        properties.put("timeoutSeconds", protocol2.getHttp().getTimeoutSeconds());
        properties.put("dnsLookupEnabled", protocol2.getHttp().getDnsLookupEnabled());
        properties.put("xFrameOptions", protocol2.getHttp().getXframeOptions());
        properties.put("http2Enabled", protocol2.getHttp().getHttp2Enabled());
        properties.put("http2MaxConcurrentStreams", protocol2.getHttp().getHttp2MaxConcurrentStreams());
        properties.put("http2InitialWindowSizeInBytes", protocol2.getHttp().getHttp2InitialWindowSizeInBytes());
        properties.put("http2MaxFramePayloadSizeInBytes", protocol2.getHttp().getHttp2MaxFramePayloadSizeInBytes());
        properties.put("http2MaxHeaderListSizeInBytes", protocol2.getHttp().getHttp2MaxHeaderListSizeInBytes());
        properties.put("http2StreamsHighWaterMark", protocol2.getHttp().getHttp2StreamsHighWaterMark());
        properties.put("http2CleanPercentage", protocol2.getHttp().getHttp2CleanPercentage());
        properties.put("http2CleanFrequencyCheck", protocol2.getHttp().getHttp2CleanFrequencyCheck());
        properties.put("http2DisableCipherCheck", protocol2.getHttp().getHttp2DisableCipherCheck());
        properties.put("http2PushEnabled", protocol2.getHttp().getHttp2PushEnabled());
        report.setExtraProperties(properties);
    }
}

