/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.InvocationHandlerUtil;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.ejb.AccessLocalException;
import jakarta.ejb.EJBException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.UnmarshalException;
import java.util.Map;
import org.glassfish.api.invocation.InvocationManager;

public final class WebServiceInvocationHandler
extends EJBLocalRemoteObject
implements InvocationHandler {
    private final WebServiceEndpoint endpoint_;
    private final Class ejbClass_;
    private final Class serviceEndpointIntfClass_;
    private final InvocationManager invManager_;
    private final boolean hasHandlers_;
    private final Map invocationInfoMap_;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebServiceInvocationHandler.class);

    public WebServiceInvocationHandler(Class ejbClass, WebServiceEndpoint endpoint, Class serviceEndpointIntfClass, EjbContainerUtil contUtil, Map invocationInfoMap) {
        this.ejbClass_ = ejbClass;
        this.serviceEndpointIntfClass_ = serviceEndpointIntfClass;
        this.endpoint_ = endpoint;
        this.hasHandlers_ = endpoint.hasHandlers();
        this.invManager_ = contUtil.getInvocationManager();
        this.invocationInfoMap_ = invocationInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            this.container.onEnteringContainer();
            Class<?> methodClass = method.getDeclaringClass();
            if (methodClass == Object.class) {
                Object object = InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
                return object;
            }
            EjbInvocation inv = (EjbInvocation)this.invManager_.getCurrentInvocation();
            Object returnValue = this.invoke(method, args, inv);
            if (inv.exception != null) {
                if (inv.exception instanceof RuntimeException) {
                    throw (RuntimeException)inv.exception;
                }
                if (inv.exception instanceof Exception) {
                    throw inv.exception;
                }
                EJBException ejbEx = new EJBException(inv.exception.getMessage());
                ejbEx.initCause(inv.exception);
                throw ejbEx;
            }
            Object object = returnValue;
            return object;
        }
        finally {
            this.container.onLeavingContainer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(Method method, Object[] args, EjbInvocation inv) throws Exception {
        try {
            Method beanClassMethod;
            ComponentContext ctx;
            Method methodBefore;
            inv.ejbObject = this;
            if (this.endpoint_.getServiceEndpointInterface().equals(this.ejbClass_.getName())) {
                method = this.ejbClass_.getMethod(method.getName(), method.getParameterTypes());
            }
            inv.method = method;
            inv.clientInterface = this.serviceEndpointIntfClass_;
            inv.invocationInfo = (InvocationInfo)this.invocationInfoMap_.get(inv.method);
            if (inv.invocationInfo == null) {
                throw new EJBException("Web service Invocation Info lookup failed for method " + inv.method);
            }
            inv.transactionAttribute = inv.invocationInfo.txAttr;
            if (this.endpoint_.getWebService().hasMappingFile()) {
                boolean authorized;
                if (!this.hasHandlers_ && !(authorized = this.container.authorize(inv))) {
                    throw new AccessLocalException("Client not authorized to access " + inv.method);
                }
            } else if (this.hasHandlers_ && (methodBefore = inv.getWebServiceMethod()) != null && !methodBefore.equals(inv.method)) {
                inv.exception = new UnmarshalException(localStrings.getLocalString("enterprise.webservice.postHandlerMethodMismatch", "Original Method {0} does not match post-handler method {1}", new Object[]{methodBefore, inv.method}));
                throw inv.exception;
            }
            inv.context = ctx = this.container.getContext(inv);
            inv.instance = inv.ejb = ctx.getEJB();
            this.container.preInvokeTx(inv);
            inv.beanMethod = beanClassMethod = this.ejbClass_.getMethod(method.getName(), method.getParameterTypes());
            inv.methodParams = args;
            Object object = this.container.intercept(inv);
            return object;
        }
        catch (NoSuchMethodException nsme) {
            inv.exception = nsme;
            Object var5_11 = null;
            return var5_11;
        }
        catch (InvocationTargetException ite) {
            inv.exception = ite.getCause();
            Object var5_12 = null;
            return var5_12;
        }
        catch (Throwable c) {
            inv.exception = c;
            Object var5_13 = null;
            return var5_13;
        }
        finally {
            if (inv.ejb != null) {
                this.container.postInvokeTx(inv);
            }
        }
    }
}

