/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.annotations;

import fish.payara.security.annotations.ClaimsDefinition;
import fish.payara.security.annotations.LogoutDefinition;
import fish.payara.security.annotations.OpenIdProviderMetadata;
import fish.payara.security.openid.api.DisplayType;
import fish.payara.security.openid.api.PromptType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface AzureAuthenticationDefinition {
    public static final String OPENID_MP_AZURE_TENANT_ID = "payara.security.openid.azure.tenantId";

    public String tenantId() default "";

    public String providerURI() default "https://login.microsoftonline.com/{tenantid}/v2.0";

    public OpenIdProviderMetadata providerMetadata() default @OpenIdProviderMetadata;

    public ClaimsDefinition claimsDefinition() default @ClaimsDefinition;

    public LogoutDefinition logout() default @LogoutDefinition;

    public String clientId() default "";

    public String clientSecret() default "";

    public String redirectURI() default "${baseURL}/Callback";

    public String[] scope() default {"openid", "email", "profile"};

    public String responseType() default "code";

    public String responseMode() default "";

    public PromptType[] prompt() default {};

    public DisplayType display() default DisplayType.PAGE;

    public boolean useNonce() default true;

    public boolean useSession() default true;

    public String[] extraParameters() default {};

    public int jwksConnectTimeout() default 500;

    public int jwksReadTimeout() default 500;

    public boolean tokenAutoRefresh() default true;

    public int tokenMinValidity() default 10000;

    public boolean userClaimsFromIDToken() default false;
}

