/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.eventbus;

import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.MessageReceiver;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TopicListener
implements MessageListener {
    private final String topicName;
    private UUID registrationID;
    private final Set<MessageReceiver> receivers;

    public TopicListener(String topicName) {
        this.topicName = topicName;
        this.receivers = ConcurrentHashMap.newKeySet(2);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public UUID getRegistrationID() {
        return this.registrationID;
    }

    public void setRegistrationID(UUID registrationID) {
        this.registrationID = registrationID;
    }

    int getReceiverCount() {
        return this.receivers.size();
    }

    public void onMessage(Message msg) {
        for (MessageReceiver receiver : this.receivers) {
            receiver.receiveMessage((ClusterMessage)msg.getMessageObject());
        }
    }

    void addMessageReceiver(MessageReceiver mr) {
        this.receivers.add(mr);
    }

    int removeMessageReceiver(MessageReceiver mr) {
        this.receivers.remove(mr);
        return this.receivers.size();
    }
}

