/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast.admin;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import jakarta.inject.Inject;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-hazelcast-members")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list-hazelcast-members")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DEPLOYMENT_GROUP, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-hazelcast-members", description="Lists Hazelcast cluster members")})
public class ListHazelcastMembers
implements AdminCommand {
    @Inject
    HazelcastCore hazelcast;
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        if (this.hazelcast.isEnabled()) {
            HazelcastInstance instance = this.hazelcast.getInstance();
            if (instance != null) {
                StringBuilder builder = new StringBuilder();
                builder.append("{ ");
                for (Member member : instance.getCluster().getMembers()) {
                    String groupName;
                    String memberName = this.hazelcast.getAttribute(member.getUuid(), "GLASSFISH-INSTANCE");
                    if (memberName != null) {
                        builder.append(memberName).append("-");
                    }
                    if ((groupName = member.getAttribute("GLASSFISH_INSTANCE_GROUP")) != null) {
                        builder.append(groupName).append("-");
                    }
                    builder.append(member.getSocketAddress().toString());
                    if (member.localMember()) {
                        builder.append("-this");
                    }
                    if (member.isLiteMember()) {
                        builder.append("-LITE");
                    }
                    builder.append(" ");
                }
                builder.append('}');
                actionReport.setMessage(builder.toString());
                Properties extraProps = new Properties();
                StringBuilder extraBuilder = new StringBuilder(actionReport.getMessage());
                extraBuilder.append("<br/>");
                for (ActionReport subReport : actionReport.getSubActionsReport()) {
                    extraBuilder.append(subReport.getMessage()).append("<br/>");
                }
                extraProps.put("Members", extraBuilder.toString());
                actionReport.setExtraProperties(extraProps);
            }
        } else {
            Properties extraProps = new Properties();
            extraProps.put("Members", "Hazelcast is not enabled");
            actionReport.setExtraProperties(extraProps);
            actionReport.setMessage("Hazelcast is not enabled");
        }
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

