/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import java.io.IOException;
import org.glassfish.grizzly.config.ConfigAwareElement;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.hk2.api.ServiceLocator;

public class HSTSFilter
extends BaseFilter
implements ConfigAwareElement<Ssl> {
    private static final String HSTS_HEADER = "Strict-Transport-Security";
    private static final String MAX_AGE = "max-age=31536000";
    private static final String SUBDOMAINS_HEADER = "; includeSubDomains";
    private static final String PRELOAD_HEADER = "; preload";
    private boolean enabled;
    private boolean includeSubdomains;
    private boolean preload;
    private String header;

    @Override
    public void configure(ServiceLocator habitat, NetworkListener networkListener, Ssl configuration) {
        this.enabled = Boolean.parseBoolean(configuration.getHstsEnabled());
        this.includeSubdomains = Boolean.parseBoolean(configuration.getHstsSubdomains());
        this.preload = Boolean.parseBoolean(configuration.getHstsPreload());
        this.header = MAX_AGE;
        if (this.includeSubdomains) {
            this.header = this.header + SUBDOMAINS_HEADER;
        }
        if (this.preload) {
            this.header = this.header + PRELOAD_HEADER;
        }
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        if (message instanceof HttpContent && this.enabled) {
            HttpContent content = (HttpContent)message;
            content.getHttpHeader().addHeader(HSTS_HEADER, this.header);
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        HttpContent content;
        Object message = ctx.getMessage();
        if (message instanceof HttpContent && this.enabled && !(content = (HttpContent)message).getHttpHeader().containsHeader(HSTS_HEADER)) {
            content.getHttpHeader().addHeader(HSTS_HEADER, this.header);
        }
        return ctx.getInvokeAction();
    }
}

